/*
 * Decompiled with CFR 0.152.
 */
package deepgo.jena;

import deepgo.Functions;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PFuncListAndList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.IterLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class deepGO
extends PFuncListAndList {
    Logger logger = LoggerFactory.getLogger(deepGO.class);

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        if (argSubject.getArgListSize() != 4) {
            throw new QueryBuildException("Subject list must contain exactly 3 variables, GO subontology, GO IRI, label, score");
        }
        if (argObject.getArgListSize() != 2) {
            throw new QueryBuildException("Object list must contain exactly two arguments, sequence and threshold");
        }
    }

    public QueryIterator execEvaluated(Binding binding, PropFuncArg subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        double threshold;
        String sequence = object.getArg(0).toString().replace("\"", "");
        ArrayList<String[]> arr = Functions.deepgo(sequence, threshold = Double.parseDouble(object.getArg(1).getLiteralLexicalForm().toString()));
        if (arr.size() == 0) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        ArrayList<Node[]> result = new ArrayList<Node[]>();
        for (int i = 0; i < arr.size(); ++i) {
            result.add(new Node[]{NodeValue.makeNodeString((String)arr.get(i)[0]).asNode(), NodeFactory.createURI((String)arr.get(i)[1]), NodeValue.makeNodeString((String)arr.get(i)[2]).asNode(), NodeValue.makeNodeDouble((double)Double.parseDouble(arr.get(i)[3])).asNode()});
        }
        Node subOnt = subject.getArg(0);
        Node node = subject.getArg(1);
        Node label = subject.getArg(2);
        Node score = subject.getArg(3);
        if (Var.isVar((Node)subOnt) && Var.isVar((Node)node) && Var.isVar((Node)label) && Var.isVar((Node)score)) {
            Var subVar = Var.alloc((Node)subOnt);
            Var nodeVar = Var.alloc((Node)node);
            Var labelVar = Var.alloc((Node)label);
            Var scoreVar = Var.alloc((Node)score);
            Iterator it = Iter.map(result.iterator(), item -> {
                BindingMap b = BindingFactory.create((Binding)binding);
                b.add(subVar, item[0]);
                b.add(nodeVar, item[1]);
                b.add(labelVar, item[2]);
                b.add(scoreVar, item[3]);
                return b;
            });
            return new QueryIterPlainWrapper(it, execCxt);
        }
        return IterLib.noResults((ExecutionContext)execCxt);
    }
}

