/*
 * Decompiled with CFR 0.152.
 */
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import deepgo.jena.DeepGOPropertyFunctionFactory;
import org.apache.jena.fuseki.embedded.FusekiServer;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    Logger logger = LoggerFactory.getLogger(Main.class);
    @Parameter(names={"--port", "-p"}, required=false)
    int port = 3330;

    public void run() throws Exception {
        this.logger.info("Run function is excecuted");
        FusekiServer.Builder fsb = FusekiServer.create().setPort(this.port);
        PropertyFunctionRegistry reg = PropertyFunctionRegistry.chooseRegistry((Context)ARQ.getContext());
        reg.put("http://deepgoplus.bio2vec.net/functions#deepgo", (PropertyFunctionFactory)new DeepGOPropertyFunctionFactory());
        PropertyFunctionRegistry.set((Context)ARQ.getContext(), (PropertyFunctionRegistry)reg);
        Dataset ds = DatasetFactory.create();
        fsb.add("/ds", ds, true);
        FusekiServer fs = fsb.build();
        fs.start();
    }

    public static void main(String[] args) {
        Main main = new Main();
        JCommander jcom = JCommander.newBuilder().addObject((Object)main).build();
        try {
            jcom.parse(args);
            main.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            jcom.usage();
        }
    }
}

