/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.List;
import java.util.Optional;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.sys.SystemIndex;
import org.apache.jena.dboe.trans.bplustree.AccessPath;
import org.apache.jena.dboe.trans.bplustree.BPTreeException;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreeNodeMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecordsMgr;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeParams;
import org.slf4j.Logger;

public final class BPT {
    public static boolean Logging = false;
    public static boolean forcePromoteModes = false;
    public static boolean promoteDuplicateRecords = false;
    public static boolean promoteDuplicateNodes = false;
    public static boolean CheckingNode = false;
    public static boolean CheckingConcurrency = SystemIndex.Checking;
    public static boolean DumpTree = false;

    public static void checking(boolean onOrOff) {
        CheckingNode = onOrOff;
    }

    public static void infoAll(boolean onOrOff) {
        DumpTree = true;
        Logging = true;
    }

    static boolean logging(Logger log) {
        return Logging && log.isDebugEnabled();
    }

    static void log(Logger log, String fmt, Object ... args) {
        if (BPT.logging(log)) {
            FmtLog.debug((Logger)log, (String)fmt, (Object[])args);
        }
    }

    static void warning(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println("Warning: " + msg);
        System.out.flush();
    }

    static void error(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println();
        System.out.println(msg);
        System.out.flush();
        throw new BPTreeException(msg);
    }

    static int apply(int idx) {
        if (idx >= 0) {
            return idx;
        }
        return Alg.decodeIndex((int)idx);
    }

    static boolean promote1(BPTreePage page, BPTreeNode node, int idx) {
        boolean changed = page.promote();
        node.ptrs.set(idx, page.getId());
        return changed;
    }

    static boolean promoteRoot(BPTreeNode root) {
        if (!root.isRoot()) {
            throw new InternalErrorException("Not a root");
        }
        boolean changed = root.promote();
        root.bpTree.newRoot(root);
        return changed;
    }

    static void promotePage(AccessPath path, BPTreePage page) {
        Logger pageLog = page.getLogger();
        boolean loggingCall = BPT.logging(pageLog);
        if (loggingCall) {
            BPT.log(pageLog, "Promote :: Path=%s  Page=%s", path, page);
        }
        if (CheckingNode && path != null) {
            Optional<AccessPath.AccessStep> z2;
            List<AccessPath.AccessStep> y;
            Optional<AccessPath.AccessStep> z;
            if (path.getPath().size() > 2 && (z = (y = path.getPath().subList(0, path.getPath().size() - 2)).stream().filter(e -> e.node.isLeaf()).findFirst()).isPresent()) {
                BPT.error("promote: Leaf %s found in path but not at the tail: %s", new Object[0]);
            }
            if ((z2 = path.getPath().stream().filter(e -> e.node.ptrs.get(e.idx) != e.page.getId()).findFirst()).isPresent()) {
                BPT.error("promote: path error: %s in %s", z2.get(), path);
            }
        }
        if (loggingCall) {
            BPT.log(pageLog, "   page>> %s", page.label());
        }
        boolean changed = page.promote();
        if (loggingCall) {
            if (changed) {
                BPT.log(pageLog, "   page<< %s", page.label());
            } else {
                BPT.log(pageLog, "    .. no change", new Object[0]);
            }
        }
        if (changed) {
            page.write();
        }
        if (path != null) {
            List<AccessPath.AccessStep> steps = path.getPath();
            int newPtr = page.getId();
            Object newPage = null;
            boolean previousChanged = changed;
            BPTreeNode newRoot = null;
            if (BPT.logging(pageLog)) {
                BPT.log(pageLog, "Path: %s", path);
            }
            for (int i = steps.size() - 1; i >= 0; --i) {
                AccessPath.AccessStep s = steps.get(i);
                BPTreeNode n = s.node;
                if (BPT.logging(pageLog)) {
                    BPT.log(pageLog, "    >> %s", n);
                }
                changed = n.promote();
                if (previousChanged) {
                    n.ptrs.set(s.idx, newPtr);
                } else if (!changed) {
                    if (!BPT.logging(pageLog)) continue;
                    BPT.log(pageLog, "    .. no change", new Object[0]);
                    continue;
                }
                previousChanged = changed;
                if (BPT.logging(pageLog)) {
                    BPT.log(pageLog, "    << %s", n);
                }
                if (n.isRoot()) {
                    if (newRoot != null) {
                        throw new InternalErrorException("New root already found");
                    }
                    newRoot = n;
                }
                newPtr = n.getId();
                n.write();
            }
            if (newRoot != null) {
                if (loggingCall) {
                    BPT.log(pageLog, "  new root %s", newRoot);
                }
                page.bpTree.newRoot(newRoot);
            }
        }
    }

    public static BPlusTree createRootOnlyBPTree(BPlusTreeParams bptParams, BufferChannel bptState, BlockMgr blkMgrNodes, BlockMgr blkMgrRecords) {
        BPlusTree bpt = BPlusTreeFactory.createNonTxn(bptParams, bptState, blkMgrNodes, blkMgrRecords);
        BPTreeRecordsMgr recordsMgr = bpt.getRecordsMgr();
        BPTreeRecords recordsPage = (BPTreeRecords)recordsMgr.getWrite(0);
        recordsMgr.free(recordsPage);
        recordsMgr.resetAlloc(0L);
        BPTreeNodeMgr nodeMgr = bpt.getNodeManager();
        BPTreeNode root = nodeMgr.getWrite(0, -2);
        int rootId = root.getId();
        if (rootId != 0) {
            throw new BPTreeException("**** Not the root: " + rootId);
        }
        root.getPtrBuffer().clear();
        root.getRecordBuffer().clear();
        nodeMgr.write(root);
        nodeMgr.release(root);
        return bpt;
    }
}

