/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphWrapper
implements Graph {
    private final Graph graph;

    public GraphWrapper(Graph graph) {
        this.graph = graph;
    }

    public Graph get() {
        return this.graph;
    }

    public void add(Triple t) throws AddDeniedException {
        this.graph.add(t);
    }

    public boolean dependsOn(Graph other) {
        return this.graph.dependsOn(other);
    }

    public TransactionHandler getTransactionHandler() {
        return this.graph.getTransactionHandler();
    }

    public Capabilities getCapabilities() {
        return this.graph.getCapabilities();
    }

    public GraphEventManager getEventManager() {
        return this.graph.getEventManager();
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return this.graph.getStatisticsHandler();
    }

    public PrefixMapping getPrefixMapping() {
        return this.graph.getPrefixMapping();
    }

    public void delete(Triple t) throws DeleteDeniedException {
        this.graph.delete(t);
    }

    public ExtendedIterator<Triple> find(Triple triple) {
        return this.graph.find(triple);
    }

    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return this.graph.find(s, p, o);
    }

    public boolean isIsomorphicWith(Graph g) {
        return this.graph.isIsomorphicWith(g);
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.graph.contains(s, p, o);
    }

    public boolean contains(Triple t) {
        return this.graph.contains(t);
    }

    public void close() {
        this.graph.close();
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public int size() {
        return this.graph.size();
    }

    public boolean isClosed() {
        return this.graph.isClosed();
    }

    public void clear() {
        this.graph.clear();
    }

    public void remove(Node s, Node p, Node o) {
        this.graph.remove(s, p, o);
    }
}

