/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetOneAssembler
extends AssemblerBase {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDatasetOne;
    }

    public Object open(Assembler a, Resource root2, Mode mode) {
        Dataset ds = this.createDataset(a, root2, mode);
        return ds;
    }

    public Dataset createDataset(Assembler a, Resource root2, Mode mode) {
        Resource dftGraphDesc1 = GraphUtils.getResourceValue(root2, DatasetAssemblerVocab.pDefaultGraph);
        Resource dftGraphDesc2 = GraphUtils.getResourceValue(root2, DatasetAssemblerVocab.pGraph);
        if (dftGraphDesc1 != null && dftGraphDesc2 != null) {
            throw new AssemblerException(root2, "Found both ja:graph and ja:defaultGraph");
        }
        Resource graphDesc = dftGraphDesc1 != null ? dftGraphDesc1 : dftGraphDesc2;
        Model model = graphDesc != null ? a.openModel(graphDesc) : GraphFactory.makeDefaultModel();
        Dataset ds = DatasetFactory.wrap(model);
        List<RDFNode> nodes = GraphUtils.multiValue(root2, DatasetAssemblerVocab.pNamedGraph);
        if (!nodes.isEmpty()) {
            String x = DatasetAssemblerVocab.tDatasetOne.getLocalName();
            throw new AssemblerException(root2, "A " + x + " dataset can only hold a default graph, and no named graphs");
        }
        AssemblerUtils.setContext(root2, ds.getContext());
        return ds;
    }
}

