/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.riot.resultset.rw.ResultsReader;
import org.apache.jena.riot.resultset.rw.ResultsWriter;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSystem;

public class ResultSetMgr {
    public static ResultSet read(String urlOrFilename) {
        ResultSet rs = ResultSetMgr.readAny(urlOrFilename).getResultSet();
        if (rs == null) {
            throw new ResultSetException("Not a result set");
        }
        return rs;
    }

    public static ResultSet read(String urlOrFilename, Lang lang) {
        ResultSet rs = ResultSetMgr.readAny(urlOrFilename, lang).getResultSet();
        if (rs == null) {
            throw new ResultSetException("Not a result set");
        }
        return rs;
    }

    public static ResultSet read(InputStream input) {
        ResultSet rs = ResultSetMgr.readAny(input).getResultSet();
        if (rs == null) {
            throw new ResultSetException("Not a result set");
        }
        return rs;
    }

    public static ResultSet read(InputStream input, Lang lang) {
        ResultSet rs = ResultSetMgr.readAny(input, lang).getResultSet();
        if (rs == null) {
            throw new ResultSetException("Not a result set");
        }
        return rs;
    }

    private static void checkLang(Lang lang) {
        Objects.requireNonNull(lang);
        if (!ResultSetReaderRegistry.isRegistered(lang)) {
            throw new ResultSetException("Not a result set syntax: " + lang);
        }
    }

    public static boolean readBoolean(String urlOrFilename) {
        Boolean b = ResultSetMgr.readAny(urlOrFilename).getBooleanResult();
        return b;
    }

    public static boolean readBoolean(String urlOrFilename, Lang lang) {
        Boolean b = ResultSetMgr.readAny(urlOrFilename, lang).getBooleanResult();
        return b;
    }

    public static boolean readBoolean(InputStream input) {
        Boolean b = ResultSetMgr.readAny(input).getBooleanResult();
        return b;
    }

    public static boolean readBoolean(InputStream input, Lang lang) {
        Boolean b = ResultSetMgr.readAny(input, lang).getBooleanResult();
        return b;
    }

    private static SPARQLResult readAny(String url) {
        return ResultsReader.create().build().readAny(url);
    }

    private static SPARQLResult readAny(String url, Lang lang) {
        ResultSetMgr.checkLang(lang);
        return ResultsReader.create().lang(lang).build().readAny(url);
    }

    private static SPARQLResult readAny(InputStream input) {
        return ResultsReader.create().build().readAny(input);
    }

    private static SPARQLResult readAny(InputStream input, Lang lang) {
        ResultSetMgr.checkLang(lang);
        return ResultsReader.create().lang(lang).build().readAny(input);
    }

    public static ResultSet parse(String uri, Lang hintLang, Context context) {
        ResultSet rs = ResultsReader.create().lang(hintLang).context(context).read(uri);
        if (rs == null) {
            throw new ResultSetException("Not a result set");
        }
        return rs;
    }

    public static void write(OutputStream output, ResultSet resultSet, Lang lang) {
        Objects.requireNonNull(lang);
        ResultsWriter.create().lang(lang).write(output, resultSet);
    }

    public static void write(OutputStream output, boolean result, Lang lang) {
        Objects.requireNonNull(lang);
        ResultsWriter.create().lang(lang).build().write(output, result);
    }

    public static String asString(ResultSet resultSet, Lang lang) {
        Objects.requireNonNull(lang);
        ByteArrayOutputStream output = new ByteArrayOutputStream(1000);
        ResultsWriter.create().lang(lang).write(output, resultSet);
        return StrUtils.fromUTF8bytes((byte[])output.toByteArray());
    }

    public static String asString(boolean result, Lang lang) {
        Objects.requireNonNull(lang);
        ByteArrayOutputStream output = new ByteArrayOutputStream(1000);
        ResultsWriter.create().lang(lang).build().write((OutputStream)output, result);
        return StrUtils.fromUTF8bytes((byte[])output.toByteArray());
    }

    static {
        JenaSystem.init();
    }
}

