/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.fuseki.validation.json.ValidatorJsonLib;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateValidatorJSON {
    static final String paramUpdate = "update";
    static final String paramSyntax = "languageSyntax";
    static final String jInput = "input";
    static final String jFormatted = "formatted";

    public static JsonObject execute(ValidationAction action) {
        Syntax language;
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String updateString = ValidatorJsonLib.getArg(action, paramUpdate);
        String updateSyntax = ValidatorJsonLib.getArgOrNull(action, paramSyntax);
        if (updateSyntax == null || updateSyntax.equals("")) {
            updateSyntax = "SPARQL";
        }
        if ((language = Syntax.lookup((String)updateSyntax)) == null) {
            ServletOps.errorBadRequest("Unknown syntax: " + updateSyntax);
            return null;
        }
        obj.key(jInput).value(updateString);
        UpdateRequest request = null;
        try {
            request = UpdateFactory.create((String)updateString, (String)"http://example/base/", (Syntax)language);
        }
        catch (QueryParseException ex) {
            obj.key("errors");
            obj.startArray();
            obj.startObject();
            obj.key("parse-error").value(ex.getMessage());
            obj.key("parse-error-line").value((long)ex.getLine());
            obj.key("parse-error-column").value((long)ex.getColumn());
            obj.finishObject();
            obj.finishArray();
            obj.finishObject();
            return obj.build().getAsObject();
        }
        UpdateValidatorJSON.formatted(obj, request);
        obj.finishObject();
        return obj.build().getAsObject();
    }

    private static void formatted(JsonBuilder obj, UpdateRequest updateRequest) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        updateRequest.output((IndentedWriter)out);
        obj.key(jFormatted).value(out.asString());
    }
}

