/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletInputStream;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.UploadDetails;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class Upload {
    public static UploadDetails incomingData(HttpAction action, StreamRDF dest) {
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No content type");
            return null;
        }
        if (WebContent.matchContentType((ContentType)WebContent.ctMultipartFormData, (ContentType)ct)) {
            return Upload.fileUploadWorker(action, dest);
        }
        String base = ActionLib.wholeRequestURL(action.request);
        Lang lang = RDFLanguages.contentTypeToLang((String)ct.getContentType());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + ct);
            return null;
        }
        ServletInputStream input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
        long len = action.request.getContentLengthLong();
        StreamRDFCounting countingDest = StreamRDFLib.count((StreamRDF)dest);
        try {
            ActionLib.parse(action, (StreamRDF)countingDest, (InputStream)input, lang, base);
            UploadDetails details = new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
            action.log.info(String.format("[%d] Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s : %s", action.id, len, ct.getContentType(), ct.getCharset(), lang.getName(), details.detailsStr()));
            return details;
        }
        catch (RiotParseException ex) {
            action.log.info(String.format("[%d] Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s : %s", action.id, len, ct.getContentType(), ct.getCharset(), lang.getName(), ex.getMessage()));
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadDetails fileUploadWorker(HttpAction action, StreamRDF dest) {
        String base = ActionLib.wholeRequestURL(action.request);
        ServletFileUpload upload = new ServletFileUpload();
        StreamRDFCounting countingDest = StreamRDFLib.count((StreamRDF)dest);
        try {
            FileItemIterator iter = upload.getItemIterator(action.request);
            while (iter.hasNext()) {
                String printfilename;
                FileItemStream fileStream = iter.next();
                if (fileStream.isFormField()) {
                    String fieldName = fileStream.getFieldName();
                    InputStream stream = fileStream.openStream();
                    String value = Streams.asString((InputStream)stream, (String)"UTF-8");
                    ServletOps.errorBadRequest(String.format("Only files accepted in multipart file upload (got %s=%s)", fieldName, value));
                }
                InputStream stream = fileStream.openStream();
                String contentTypeHeader = fileStream.getContentType();
                ContentType ct = ContentType.create((String)contentTypeHeader);
                Lang lang = null;
                if (!WebContent.matchContentType((ContentType)WebContent.ctTextPlain, (ContentType)ct)) {
                    lang = RDFLanguages.contentTypeToLang((String)ct.getContentType());
                }
                if (lang == null) {
                    String name = fileStream.getName();
                    if (name == null || name.equals("")) {
                        ServletOps.errorBadRequest("No name for content - can't determine RDF syntax");
                    }
                    lang = RDFLanguages.filenameToLang((String)name);
                    if (name.endsWith(".gz")) {
                        stream = new GZIPInputStream(stream);
                    }
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                if ((printfilename = fileStream.getName()) == null || printfilename.equals("")) {
                    printfilename = "<none>";
                }
                StreamRDFCounting countingDest2 = StreamRDFLib.count((StreamRDF)countingDest);
                try {
                    ActionLib.parse(action, (StreamRDF)countingDest2, stream, lang, base);
                    UploadDetails details1 = new UploadDetails(countingDest2.count(), countingDest2.countTriples(), countingDest2.countQuads());
                    action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentType(), ct.getCharset(), lang.getName(), details1.detailsStr()));
                }
                catch (RiotParseException ex) {
                    action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentType(), ct.getCharset(), lang.getName(), ex.getMessage()));
                    throw ex;
                }
            }
            return new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex.getMessage());
        }
        return new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
    }
}

