/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.REST_Quads_R;
import org.apache.jena.fuseki.servlets.REST_Quads_RW;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_R;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_RW;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;

public class ServiceDispatchRegistry {
    public static final ActionService queryServlet = new SPARQL_QueryDataset();
    public static final ActionService updateServlet = new SPARQL_Update();
    public static final ActionService uploadServlet = new SPARQL_Upload();
    public static final ActionService gspServlet_R = new SPARQL_GSP_R();
    public static final ActionService gspServlet_RW = new SPARQL_GSP_RW();
    public static final ActionService restQuads_R = new REST_Quads_R();
    public static final ActionService restQuads_RW = new REST_Quads_RW();
    private final Map<String, Operation> contentTypeToOperation = new ConcurrentHashMap<String, Operation>();
    private final Map<Operation, ActionService> operationToHandler = new ConcurrentHashMap<Operation, ActionService>();
    private static final String attrServiceRegistry = "jena-fuseki:ServiceDispatchRegistry";

    public Map<String, Operation> contentTypeToOperation() {
        return this.contentTypeToOperation;
    }

    public Map<Operation, ActionService> operationToHandler() {
        return this.operationToHandler;
    }

    public ServiceDispatchRegistry(ServiceDispatchRegistry other) {
        this.contentTypeToOperation.putAll(other.contentTypeToOperation);
        this.operationToHandler.putAll(other.operationToHandler);
    }

    public ServiceDispatchRegistry(boolean includeStdConfig) {
        if (includeStdConfig) {
            this.register(Operation.Query, "application/sparql-query", queryServlet);
            this.register(Operation.Update, "application/sparql-update", updateServlet);
            this.register(Operation.Upload, null, uploadServlet);
            this.register(Operation.GSP_R, null, gspServlet_R);
            this.register(Operation.GSP_RW, null, gspServlet_RW);
            this.register(Operation.Quads_R, null, restQuads_R);
            this.register(Operation.Quads_RW, null, restQuads_RW);
        }
    }

    public Operation findOperation(String contentType) {
        if (contentType == null) {
            return null;
        }
        return this.contentTypeToOperation.get(contentType);
    }

    public ActionService findHandler(Operation operation) {
        if (operation == null) {
            return null;
        }
        return this.operationToHandler.get(operation);
    }

    public boolean isRegistered(Operation operation) {
        return this.operationToHandler.containsKey(operation);
    }

    public void register(Operation operation, String contentType, ActionService action) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(action);
        if (contentType != null) {
            this.contentTypeToOperation.put(contentType, operation);
        }
        this.operationToHandler.put(operation, action);
    }

    public static ServiceDispatchRegistry get(ServletContext servletContext) {
        ServiceDispatchRegistry registry = (ServiceDispatchRegistry)servletContext.getAttribute(attrServiceRegistry);
        if (registry == null) {
            Log.warn(ServiceDispatchRegistry.class, (String)"No service registry for ServletContext");
        }
        return registry;
    }

    public static void set(ServletContext cxt, ServiceDispatchRegistry registry) {
        cxt.setAttribute(attrServiceRegistry, (Object)registry);
    }
}

