/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ResponseDataset;
import org.apache.jena.fuseki.servlets.ResponseJson;
import org.apache.jena.fuseki.servlets.ResponseResultSet;
import org.apache.jena.fuseki.servlets.SPARQL_Protocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.SPARQLResult;

public abstract class SPARQL_Query
extends SPARQL_Protocol {
    private static final String QueryParseBase = "http://server/unset-base/";
    protected static List<String> allParams = Arrays.asList("query", "default-graph-uri", "named-graph-uri", "query-ref", "stylesheet", "accept", "output", "format", "callback", "force-accept", "timeout");

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Query.setCommonHeadersForOptions(response);
        response.setHeader("Allow", "GET,OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    protected void doOptions(HttpAction action) {
        this.doOptions(action.request, (HttpServletResponse)action.response);
    }

    @Override
    protected void validate(HttpAction action) {
        String method = action.request.getMethod().toUpperCase(Locale.ROOT);
        if ("OPTIONS".equals(method)) {
            return;
        }
        if (!"POST".equals(method) && !"GET".equals(method)) {
            ServletOps.errorMethodNotAllowed("Not a GET or POST request");
        }
        if ("GET".equals(method) && action.request.getQueryString() == null) {
            ServletOps.warning(action, "Service Description / SPARQL Query / " + action.request.getRequestURI());
            ServletOps.errorNotFound("Service Description: " + action.request.getRequestURI());
        }
        this.validateParams(action, allParams);
        this.validateRequest(action);
    }

    protected abstract void validateRequest(HttpAction var1);

    protected void validateParams(HttpAction action, Collection<String> params) {
        HttpServletRequest request = action.request;
        ContentType ct = FusekiLib.getContentType(request);
        boolean mustHaveQueryParam = true;
        if (ct != null) {
            String incoming = ct.getContentType();
            if (WebContent.matchContentType((ContentType)WebContent.ctSPARQLQuery, (ContentType)ct)) {
                mustHaveQueryParam = false;
            } else if (!WebContent.matchContentType((ContentType)WebContent.ctHTMLForm, (ContentType)ct)) {
                ServletOps.error(415, "Unsupported: " + incoming);
            }
        }
        if (mustHaveQueryParam) {
            String queryStr;
            int N = SPARQL_Query.countParamOccurences(request, "query");
            if (N == 0) {
                ServletOps.errorBadRequest("SPARQL Query: No 'query=' parameter");
            }
            if (N > 1) {
                ServletOps.errorBadRequest("SPARQL Query: Multiple 'query=' parameters");
            }
            if ((queryStr = request.getParameter("query")) == null) {
                ServletOps.errorBadRequest("SPARQL Query: No query specified (no 'query=' found)");
            }
            if (queryStr.isEmpty()) {
                ServletOps.errorBadRequest("SPARQL Query: Empty query string");
            }
        }
        if (params != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (params.contains(name)) continue;
                ServletOps.warning(action, "SPARQL Query: Unrecognize request parameter (ignored): " + name);
            }
        }
    }

    @Override
    protected final void perform(HttpAction action) {
        if (action.request.getMethod().equals("OPTIONS")) {
            this.doOptions(action);
            return;
        }
        if (action.request.getMethod().equals("GET")) {
            this.executeWithParameter(action);
            return;
        }
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null || WebContent.isHtmlForm((ContentType)ct)) {
            this.executeWithParameter(action);
            return;
        }
        if (WebContent.matchContentType((ContentType)ct, (ContentType)WebContent.ctSPARQLQuery)) {
            this.executeBody(action);
            return;
        }
        ServletOps.error(415, "Bad content type: " + ct.getContentType());
    }

    protected void executeWithParameter(HttpAction action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    protected void executeBody(HttpAction action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8((InputStream)input);
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    protected void execute(String queryString, HttpAction action) {
        String queryStringLog = ServletOps.formatForLog(queryString);
        if (action.verbose) {
            String str = queryString;
            if (str.endsWith("\n")) {
                str = str.substring(0, str.length() - 1);
            }
            action.log.info(String.format("[%d] Query = \n%s", action.id, str));
        } else {
            action.log.info(String.format("[%d] Query = %s", action.id, queryStringLog));
        }
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString, (String)QueryParseBase, (Syntax)Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query);
            this.validateQuery(action, query);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (QueryParseException ex) {
            ServletOps.errorBadRequest("Parse error: \n" + queryString + "\n\r" + SPARQL_Query.messageForQueryException((QueryException)((Object)ex)));
        }
        catch (QueryException ex) {
            ServletOps.errorBadRequest("Error: \n" + queryString + "\n\r" + ex.getMessage());
        }
        try {
            action.beginRead();
            Dataset dataset = this.decideDataset(action, query, queryStringLog);
            try (QueryExecution qExec = this.createQueryExecution(query, dataset);){
                SPARQLResult result = this.executeQuery(action, qExec, query, queryStringLog);
                this.sendResults(action, result, query.getPrologue());
            }
        }
        catch (QueryParseException ex) {
            ServletOps.errorBadRequest("Query parse error: \n" + queryString + "\n\r" + SPARQL_Query.messageForQueryException((QueryException)((Object)ex)));
        }
        catch (QueryCancelledException ex) {
            SPARQL_Query.incCounter(action.getEndpoint().getCounters(), CounterName.QueryTimeouts);
            throw ex;
        }
        finally {
            action.endRead();
        }
    }

    protected abstract void validateQuery(HttpAction var1, Query var2);

    protected QueryExecution createQueryExecution(Query query, Dataset dataset) {
        return QueryExecutionFactory.create((Query)query, (Dataset)dataset);
    }

    protected SPARQLResult executeQuery(HttpAction action, QueryExecution queryExecution, Query query, String queryStringLog) {
        this.setAnyProtocolTimeouts(queryExecution, action);
        if (query.isSelectType()) {
            ResultSet rs = queryExecution.execSelect();
            rs.hasNext();
            return new SPARQLResult(rs);
        }
        if (query.isConstructType()) {
            Dataset dataset = queryExecution.execConstructDataset();
            return new SPARQLResult(dataset);
        }
        if (query.isDescribeType()) {
            Model model = queryExecution.execDescribe();
            return new SPARQLResult(model);
        }
        if (query.isAskType()) {
            boolean b = queryExecution.execAsk();
            return new SPARQLResult(b);
        }
        if (query.isJsonType()) {
            Iterator jsonIterator = queryExecution.execJsonItems();
            action.log.info(String.format("[%d] exec/json", action.id));
            return new SPARQLResult(jsonIterator);
        }
        ServletOps.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    private void setAnyProtocolTimeouts(QueryExecution qexec, HttpAction action) {
        long desiredTimeout = Long.MAX_VALUE;
        String timeoutHeader = action.request.getHeader("Timeout");
        String timeoutParameter = action.request.getParameter("timeout");
        if (timeoutHeader != null) {
            try {
                desiredTimeout = (int)(Float.parseFloat(timeoutHeader) * 1000.0f);
            }
            catch (NumberFormatException e) {
                throw new FusekiException("Timeout header must be a number", e);
            }
        }
        if (timeoutParameter != null) {
            try {
                desiredTimeout = (int)(Float.parseFloat(timeoutParameter) * 1000.0f);
            }
            catch (NumberFormatException e) {
                throw new FusekiException("timeout parameter must be a number", e);
            }
        }
        if (desiredTimeout != Long.MAX_VALUE) {
            qexec.setTimeout(desiredTimeout);
        }
    }

    protected abstract Dataset decideDataset(HttpAction var1, Query var2, String var3);

    protected void sendResults(HttpAction action, SPARQLResult result, Prologue qPrologue) {
        if (result.isResultSet()) {
            ResponseResultSet.doResponseResultSet(action, result.getResultSet(), qPrologue);
        } else if (result.isDataset()) {
            ResponseDataset.doResponseDataset(action, result.getDataset());
        } else if (result.isModel()) {
            ResponseDataset.doResponseModel(action, result.getModel());
        } else if (result.isBoolean()) {
            ResponseResultSet.doResponseResultSet(action, result.getBooleanResult());
        } else if (result.isJson()) {
            ResponseJson.doResponseJson(action, result.getJsonItems());
        } else {
            ServletOps.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return HttpOp.execHttpGetString((String)queryURI);
    }
}

