/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jena.cmd.CmdException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.DatasetDescriptionRegistry;
import org.apache.jena.fuseki.build.FusekiBuilder;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.build.Template;
import org.apache.jena.fuseki.build.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiInitialConfig;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;

public class FusekiSystem {
    public static final String runArea = "run";
    public static final String databasesLocationBase = "databases";
    public static final String backupDirNameBase = "backups";
    public static final String configDirNameBase = "configuration";
    public static final String logsNameBase = "logs";
    public static final String systemDatabaseNameBase = "system";
    public static final String systemFileAreaBase = "system_files";
    public static final String templatesNameBase = "templates";
    public static final String DFT_SHIRO_INI = "shiro.ini";
    public static final String DFT_CONFIG = "config.ttl";
    public static Path dirDatabases = null;
    public static Path dirBackups = null;
    public static Path dirConfiguration = null;
    public static Path dirLogs = null;
    public static Path dirSystemDatabase = null;
    public static Path dirFileArea = null;
    public static Path dirTemplates = null;
    private static boolean initialized = false;
    static boolean serverInitialized = false;

    static synchronized void formatBaseArea() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            FusekiEnv.setEnvironment();
            Path FUSEKI_HOME = FusekiEnv.FUSEKI_HOME;
            Path FUSEKI_BASE = FusekiEnv.FUSEKI_BASE;
            Fuseki.init();
            Fuseki.configLog.info("FUSEKI_HOME=" + (FUSEKI_HOME == null ? "unset" : FUSEKI_HOME.toString()));
            Fuseki.configLog.info("FUSEKI_BASE=" + FUSEKI_BASE.toString());
            if (FUSEKI_HOME != null) {
                if (!Files.isDirectory(FUSEKI_HOME, new LinkOption[0])) {
                    throw new FusekiConfigException("FUSEKI_HOME is not a directory: " + FUSEKI_HOME);
                }
                if (!Files.isReadable(FUSEKI_HOME)) {
                    throw new FusekiConfigException("FUSEKI_HOME is not readable: " + FUSEKI_HOME);
                }
            }
            if (Files.exists(FUSEKI_BASE, new LinkOption[0])) {
                if (!Files.isDirectory(FUSEKI_BASE, new LinkOption[0])) {
                    throw new FusekiConfigException("FUSEKI_BASE is not a directory: " + FUSEKI_BASE);
                }
                if (!Files.isWritable(FUSEKI_BASE)) {
                    throw new FusekiConfigException("FUSEKI_BASE is not writable: " + FUSEKI_BASE);
                }
            } else {
                FusekiSystem.ensureDir(FUSEKI_BASE);
            }
            dirTemplates = FusekiSystem.writeableDirectory(FUSEKI_BASE, templatesNameBase);
            dirDatabases = FusekiSystem.writeableDirectory(FUSEKI_BASE, databasesLocationBase);
            dirBackups = FusekiSystem.writeableDirectory(FUSEKI_BASE, backupDirNameBase);
            dirConfiguration = FusekiSystem.writeableDirectory(FUSEKI_BASE, configDirNameBase);
            dirLogs = FusekiSystem.writeableDirectory(FUSEKI_BASE, logsNameBase);
            dirSystemDatabase = FusekiSystem.writeableDirectory(FUSEKI_BASE, systemDatabaseNameBase);
            dirFileArea = FusekiSystem.writeableDirectory(FUSEKI_BASE, systemFileAreaBase);
            if (Files.isRegularFile(FUSEKI_BASE, new LinkOption[0])) {
                throw new FusekiConfigException("FUSEKI_BASE exists but is a file");
            }
            FusekiSystem.copyFileIfMissing(null, DFT_SHIRO_INI, FUSEKI_BASE);
            FusekiSystem.copyFileIfMissing(null, DFT_CONFIG, FUSEKI_BASE);
            for (String n : Template.templateNames) {
                FusekiSystem.copyFileIfMissing(null, n, FUSEKI_BASE);
            }
            serverInitialized = true;
        }
        catch (RuntimeException ex) {
            Fuseki.serverLog.error("Exception in server initialization", (Throwable)ex);
            throw ex;
        }
    }

    private static void copyFileIfMissing(Path src, String fn, Path dst) {
        Path dstFile = dst.resolve(fn);
        if (Files.exists(dstFile, new LinkOption[0])) {
            return;
        }
        if (src != null) {
            try {
                Files.copy(src.resolve(fn), dstFile, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException e) {
                IO.exception((String)("Failed to copy file " + src), (IOException)e);
                e.printStackTrace();
            }
        } else {
            try {
                URL url = FusekiSystem.class.getResource(fn);
                if (url == null) {
                    throw new FusekiConfigException("Failed to find resource '" + fn + "'");
                }
                InputStream in = url.openStream();
                Files.copy(in, dstFile, new CopyOption[0]);
            }
            catch (IOException e) {
                IO.exception((String)("Failed to copy file from resource: " + src), (IOException)e);
                e.printStackTrace();
            }
        }
    }

    public static void initializeDataAccessPoints(DataAccessPointRegistry registry, FusekiInitialConfig initialSetup, String configDir) {
        List<DataAccessPoint> configFileDBs = FusekiSystem.initServerConfiguration(initialSetup);
        List<DataAccessPoint> directoryDBs = FusekiConfig.readConfigurationDirectory(configDir);
        List<DataAccessPoint> systemDBs = FusekiConfig.readSystemDatabase(SystemState.getDataset());
        ArrayList<DataAccessPoint> datapoints = new ArrayList<DataAccessPoint>();
        datapoints.addAll(configFileDBs);
        datapoints.addAll(directoryDBs);
        datapoints.addAll(systemDBs);
        FusekiSystem.enable(registry, datapoints);
    }

    private static void enable(DataAccessPointRegistry registry, List<DataAccessPoint> datapoints) {
        for (DataAccessPoint dap : datapoints) {
            Fuseki.configLog.info("Register: " + dap.getName());
            registry.register(dap.getName(), dap);
        }
    }

    private static List<DataAccessPoint> initServerConfiguration(FusekiInitialConfig params) {
        ArrayList<DataAccessPoint> datasets = new ArrayList<DataAccessPoint>();
        if (params == null) {
            return datasets;
        }
        if (params.fusekiCmdLineConfigFile != null) {
            List<DataAccessPoint> confDatasets = FusekiSystem.processServerConfigFile(params.fusekiCmdLineConfigFile);
            datasets.addAll(confDatasets);
        } else if (params.fusekiServerConfigFile != null) {
            List<DataAccessPoint> confDatasets = FusekiSystem.processServerConfigFile(params.fusekiServerConfigFile);
            datasets.addAll(confDatasets);
        } else if (params.dsg != null) {
            DataAccessPoint dap = FusekiSystem.datasetDefaultConfiguration(params.datasetPath, params.dsg, params.allowUpdate);
            datasets.add(dap);
        } else if (params.argTemplateFile != null) {
            DataAccessPoint dap = FusekiSystem.configFromTemplate(params.argTemplateFile, params.datasetPath, params.allowUpdate, params.params);
            datasets.add(dap);
        }
        return datasets;
    }

    private static List<DataAccessPoint> processServerConfigFile(String configFilename) {
        if (!FileOps.exists((String)configFilename)) {
            Fuseki.configLog.warn("Configuration file '" + configFilename + "' does not exist");
            return Collections.emptyList();
        }
        Fuseki.configLog.info("Configuration file: " + configFilename);
        Model model = AssemblerUtils.readAssemblerFile((String)configFilename);
        if (model.size() == 0L) {
            return Collections.emptyList();
        }
        FusekiConfig.processServerConfig(model);
        return FusekiConfig.servicesAndDatasets(model);
    }

    private static DataAccessPoint configFromTemplate(String templateFile, String datasetPath, boolean allowUpdate, Map<String, String> params) {
        DatasetDescriptionRegistry registry = new DatasetDescriptionRegistry();
        if (params == null) {
            params = new HashMap<String, String>();
            params.put("NAME", datasetPath);
        } else if (!params.containsKey("NAME")) {
            Fuseki.configLog.warn("No NAME found in template parameters (added)");
            params.put("NAME", datasetPath);
        }
        Fuseki.configLog.info("Template file: " + templateFile);
        String dir = params.get("DIR");
        if (dir != null) {
            if (Objects.equals(dir, "--mem--")) {
                Fuseki.configLog.info("TDB dataset: in-memory");
            } else {
                if (!FileOps.exists((String)dir)) {
                    throw new CmdException("Directory not found: " + dir);
                }
                Fuseki.configLog.info("TDB dataset: directory=" + dir);
            }
        }
        datasetPath = DataAccessPoint.canonical(datasetPath);
        FusekiSystem.addGlobals(params);
        String str = TemplateFunctions.templateFile(templateFile, params, Lang.TTL);
        Lang lang = RDFLanguages.filenameToLang((String)str, (Lang)Lang.TTL);
        StringReader sr = new StringReader(str);
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (StringReader)sr, (String)datasetPath, (Lang)lang);
        Statement stmt = FusekiSystem.getOne(model, null, FusekiVocab.pServiceName, null);
        if (stmt == null) {
            StmtIterator sIter = model.listStatements(null, FusekiVocab.pServiceName, (RDFNode)null);
            if (!sIter.hasNext()) {
                ServletOps.errorBadRequest("No name given in description of Fuseki service");
            }
            sIter.next();
            if (sIter.hasNext()) {
                ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
            }
            throw new InternalErrorException("Inconsistent: getOne didn't fail the second time");
        }
        Resource subject = stmt.getSubject();
        if (!allowUpdate) {
            // empty if block
        }
        DataAccessPoint dap = FusekiBuilder.buildDataAccessPoint(subject, registry);
        return dap;
    }

    public static void addGlobals(Map<String, String> params) {
        if (params == null) {
            Fuseki.configLog.warn("FusekiServer.addGlobals : params is null", new Throwable());
            return;
        }
        if (!params.containsKey("FUSEKI_BASE")) {
            params.put("FUSEKI_BASE", FusekiSystem.pathStringOrElse(FusekiEnv.FUSEKI_BASE, "unset"));
        }
        if (!params.containsKey("FUSEKI_HOME")) {
            params.put("FUSEKI_HOME", FusekiSystem.pathStringOrElse(FusekiEnv.FUSEKI_HOME, "unset"));
        }
    }

    private static String pathStringOrElse(Path path, String dft) {
        if (path == null) {
            return dft;
        }
        return path.toString();
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static DataAccessPoint datasetDefaultConfiguration(String name, DatasetGraph dsg, boolean allowUpdate) {
        name = DataAccessPoint.canonical(name);
        DataService ds = FusekiBuilder.buildDataServiceStd(dsg, allowUpdate);
        DataAccessPoint dap = new DataAccessPoint(name, ds);
        return dap;
    }

    private static void ensureDir(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new FusekiConfigException("Failed to create directory: " + directory);
            }
        } else if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + directory);
        }
    }

    private static void mustExist(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            throw new FusekiConfigException("Does not exist: " + directory);
        }
        if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + directory);
        }
    }

    private static boolean emptyDir(Path dir) {
        return dir.toFile().list().length <= 2;
    }

    private static boolean exists(Path directory) {
        File dir = directory.toFile();
        return dir.exists();
    }

    private static Path writeableDirectory(Path root, String relName) {
        Path p = FusekiSystem.makePath(root, relName);
        FusekiSystem.ensureDir(p);
        if (!Files.isWritable(p)) {
            throw new FusekiConfigException("Not writable: " + p);
        }
        return p;
    }

    private static Path makePath(Path root, String relName) {
        Path path = root.resolve(relName);
        return path;
    }

    public static String datasetNameToConfigurationFile(HttpAction action, String dsName) {
        List<String> existing = FusekiSystem.existingConfigurationFile(dsName);
        if (!existing.isEmpty()) {
            if (existing.size() > 1) {
                action.log.warn(String.format("[%d] Multiple existing configuration files for %s : %s", action.id, dsName, existing));
                ServletOps.errorBadRequest("Multiple existing configuration files for " + dsName);
                return null;
            }
            return existing.get(0).toString();
        }
        return FusekiSystem.generateConfigurationFilename(dsName);
    }

    public static String generateConfigurationFilename(String dsName) {
        String filename = dsName;
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        Path p = dirConfiguration.resolve(filename + ".ttl");
        return p.toString();
    }

    public static List<String> existingConfigurationFile(String baseFilename) {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirConfiguration, baseFilename + ".*");){
                stream.forEach(p -> paths.add(dirConfiguration.resolve((Path)p).toString()));
            }
            return paths;
        }
        catch (IOException ex) {
            throw new InternalErrorException("Failed to read configuration directory " + dirConfiguration);
        }
    }
}

