/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiInitialConfig;
import org.apache.jena.fuseki.server.Operation;
import org.slf4j.Logger;

public class FusekiInfo {
    public static void info(FusekiInitialConfig serverConfig, DataAccessPointRegistry registry) {
        if (!serverConfig.verbose) {
            return;
        }
        if (serverConfig.quiet) {
            return;
        }
        Logger log = Fuseki.serverLog;
        FmtLog.info((Logger)log, (String)"Apache Jena Fuseki", (Object[])new Object[0]);
        Map<String, List<String>> z = FusekiInfo.description(registry);
        if (serverConfig.datasetPath != null) {
            if (z.size() != 1) {
                log.error("Expected only one dataset");
            }
            List<String> endpoints2 = z.get(serverConfig.datasetPath);
            FmtLog.info((Logger)log, (String)"Dataset Type = %s", (Object[])new Object[]{serverConfig.datasetDescription});
            FmtLog.info((Logger)log, (String)"Path = %s; Services = %s", (Object[])new Object[]{serverConfig.datasetPath, endpoints2});
        }
        if (serverConfig.fusekiServerConfigFile != null) {
            FmtLog.info((Logger)log, (String)"Configuration file %s", (Object[])new Object[]{serverConfig.fusekiServerConfigFile});
            z.forEach((name, endpoints) -> FmtLog.info((Logger)log, (String)"Path = %s; Services = %s", (Object[])new Object[]{name, endpoints}));
        }
        FusekiInfo.logDetails(log);
    }

    private static Map<String, List<String>> description(DataAccessPointRegistry reg) {
        LinkedHashMap<String, List<String>> desc = new LinkedHashMap<String, List<String>>();
        reg.forEach((ds, dap) -> {
            ArrayList endpoints = new ArrayList();
            desc.put((String)ds, endpoints);
            DataService dSrv = dap.getDataService();
            dSrv.getOperations().forEach(op -> dSrv.getEndpoints((Operation)op).forEach(ep -> {
                String x = ep.getEndpoint();
                if (x.isEmpty()) {
                    x = "quads";
                }
                endpoints.add(x);
            }));
        });
        return desc;
    }

    public static void logDetails(Logger log) {
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        Function<Long, String> f = FusekiInfo::strNum2;
        FmtLog.info((Logger)log, (String)"  Fuseki: %s", (Object[])new Object[]{Fuseki.VERSION});
        FmtLog.info((Logger)log, (String)"  Java:   %s", (Object[])new Object[]{System.getProperty("java.version")});
        FmtLog.info((Logger)log, (String)"  Memory: max=%s", (Object[])new Object[]{f.apply(maxMem)});
        FmtLog.info((Logger)log, (String)"  OS:     %s %s %s", (Object[])new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
    }

    public static void logDetailsVerbose(Logger log) {
        FusekiInfo.logDetails(log);
        FusekiInfo.logOne(log, "java.vendor");
        FusekiInfo.logOne(log, "java.home");
        FusekiInfo.logOne(log, "java.runtime.version");
        FusekiInfo.logOne(log, "java.runtime.name");
        FusekiInfo.logOne(log, "user.language");
        FusekiInfo.logOne(log, "user.timezone");
        FusekiInfo.logOne(log, "user.country");
        FusekiInfo.logOne(log, "user.dir");
    }

    private static void logOne(Logger log, String property) {
        FmtLog.info((Logger)log, (String)"    %-20s = %s", (Object[])new Object[]{property, System.getProperty(property)});
    }

    public static String strNumMixed(long x) {
        if (x < 1024L) {
            return Long.toString(x);
        }
        if (x < 0x100000L) {
            return String.format("%.1fK", (double)x / 1024.0);
        }
        if (x < 0x40000000L) {
            return String.format("%.1fM", (double)x / 1048576.0);
        }
        if (x < 0x10000000000L) {
            return String.format("%.1fG", (double)x / 1.073741824E9);
        }
        return String.format("%.1fT", (double)x / 1.099511627776E12);
    }

    public static String strNum10(long x) {
        if (x < 1000L) {
            return Long.toString(x);
        }
        if (x < 1000000L) {
            return String.format("%.1fK", (double)x / 1000.0);
        }
        if (x < 1000000000L) {
            return String.format("%.1fM", (double)x / 1000000.0);
        }
        if (x < 1000000000000L) {
            return String.format("%.1fG", (double)x / 1.0E9);
        }
        return String.format("%.1fT", (double)x / 1.0E12);
    }

    public static String strNum2(long x) {
        if (x < 1024L) {
            return Long.toString(x);
        }
        if (x < 0x100000L) {
            return String.format("%.1f KiB", (double)x / 1024.0);
        }
        if (x < 0x40000000L) {
            return String.format("%.1f MiB", (double)x / 1048576.0);
        }
        if (x < 0x10000000000L) {
            return String.format("%.1f GiB", (double)x / 1.073741824E9);
        }
        return String.format("%.1fTiB", (double)x / 1.099511627776E12);
    }
}

