/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.nio.file.Path;
import java.nio.file.Paths;

public class FusekiEnv {
    private static final boolean LogInit = false;
    static final boolean isWindows = FusekiEnv.determineIfWindows();
    static final String DFT_FUSEKI_BASE = isWindows ? "/etc/fuseki" : "/etc/fuseki";
    public static INIT mode = INIT.UNSET;
    public static Path FUSEKI_HOME = null;
    public static Path FUSEKI_BASE = null;
    public static final String ENV_runArea = "run";
    private static boolean initialized = false;

    private static boolean determineIfWindows() {
        String s = System.getProperty("os.name");
        if (s == null) {
            return false;
        }
        return s.startsWith("Windows ");
    }

    public static synchronized void setEnvironment() {
        if (initialized) {
            return;
        }
        FusekiEnv.resetEnvironment();
    }

    public static synchronized void resetEnvironment() {
        initialized = true;
        FusekiEnv.logInit("FusekiEnv:Start: ENV_FUSEKI_HOME = %s : ENV_FUSEKI_BASE = %s : MODE = %s", new Object[]{FUSEKI_HOME, FUSEKI_BASE, mode});
        if (mode == null || mode == INIT.UNSET) {
            mode = INIT.WAR;
        }
        if (FUSEKI_HOME == null) {
            String x1 = FusekiEnv.getenv("FUSEKI_HOME");
            if (x1 == null) {
                x1 = FusekiEnv.mode.dftFusekiHome;
            }
            if (x1 != null) {
                FUSEKI_HOME = Paths.get(x1, new String[0]);
            }
        }
        if (FUSEKI_BASE == null) {
            String x2 = FusekiEnv.getenv("FUSEKI_BASE");
            if (x2 == null) {
                x2 = FusekiEnv.mode.dftFusekiBase;
            }
            if (x2 != null) {
                FUSEKI_BASE = Paths.get(x2, new String[0]);
            } else if (FUSEKI_HOME != null) {
                FUSEKI_BASE = FUSEKI_HOME.resolve(ENV_runArea);
            } else {
                FusekiEnv.logInitError("Can't find a setting for FUSEKI_BASE - guessing wildy", new Object[0]);
                FUSEKI_BASE = Paths.get(DFT_FUSEKI_BASE, new String[0]);
            }
        }
        if (FUSEKI_HOME != null) {
            FUSEKI_HOME = FUSEKI_HOME.toAbsolutePath();
        }
        FUSEKI_BASE = FUSEKI_BASE.toAbsolutePath();
        FusekiEnv.logInit("FusekiEnv:Finish: ENV_FUSEKI_HOME = %s : ENV_FUSEKI_BASE = %s", FUSEKI_HOME, FUSEKI_BASE);
    }

    private static void logInit(String fmt, Object ... args) {
    }

    private static void logInitError(String fmt, Object ... args) {
        System.err.printf(fmt, args);
        System.err.println();
    }

    public static String getenv(String name) {
        String x = System.getenv(name);
        if (x == null) {
            x = System.getProperty(name);
        }
        return x;
    }

    public static enum INIT {
        WAR(null, "/etc/fuseki"),
        EMBEDDED(null, null),
        STANDALONE(".", "run"),
        TEST("src/main/webapp", "target/run"),
        UNSET(null, null);

        final String dftFusekiHome;
        final String dftFusekiBase;

        private INIT(String home, String base) {
            this.dftFusekiHome = home;
            this.dftFusekiBase = base;
        }
    }
}

