/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.ListMultimap;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.DatasetStatus;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;

public class DataService {
    public static final DataService dummy;
    private DatasetGraph dataset;
    private ListMultimap<Operation, Endpoint> operations = ArrayListMultimap.create();
    private Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();
    private volatile DatasetStatus state = DatasetStatus.UNINITIALIZED;
    private final CounterSet counters = new CounterSet();
    private final AtomicLong requestCounter = new AtomicLong(0L);
    private final AtomicBoolean offlineInProgress = new AtomicBoolean(false);
    private final AtomicBoolean acceptingRequests = new AtomicBoolean(true);
    public AtomicLong activeReadTxn = new AtomicLong(0L);
    public AtomicLong activeWriteTxn = new AtomicLong(0L);
    public AtomicLong totalReadTxn = new AtomicLong(0L);
    public AtomicLong totalWriteTxn = new AtomicLong(0L);

    public static DataService serviceOnlyDataService() {
        return dummy;
    }

    public DataService(DatasetGraph dataset) {
        this.dataset = dataset;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    public DataService(DataService other) {
        this.dataset = other.dataset;
        this.operations = ArrayListMultimap.create(other.operations);
        this.endpoints = new HashMap<String, Endpoint>(other.endpoints);
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public void addEndpoint(Operation operation, String endpointName) {
        Endpoint endpoint = new Endpoint(operation, endpointName);
        this.endpoints.put(endpointName, endpoint);
        this.operations.put((Object)operation, (Object)endpoint);
    }

    public Endpoint getEndpoint(String endpointName) {
        return this.endpoints.get(endpointName);
    }

    public List<Endpoint> getEndpoints(Operation operation) {
        List<Endpoint> x = this.operations.get((Object)operation);
        if (x == null) {
            x = Collections.emptyList();
        }
        return x;
    }

    public Collection<Operation> getOperations() {
        return this.operations.keySet();
    }

    public boolean allowUpdate() {
        return true;
    }

    public void goOffline() {
        this.offlineInProgress.set(true);
        this.acceptingRequests.set(false);
        this.state = DatasetStatus.OFFLINE;
    }

    public void goActive() {
        this.offlineInProgress.set(false);
        this.acceptingRequests.set(true);
        this.state = DatasetStatus.ACTIVE;
    }

    public boolean isAcceptingRequests() {
        return this.acceptingRequests.get();
    }

    public CounterSet getCounters() {
        return this.counters;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    public void startTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.getAndIncrement();
                this.totalReadTxn.getAndIncrement();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.getAndIncrement();
                this.totalWriteTxn.getAndIncrement();
            }
        }
    }

    public void finishTxn(ReadWrite mode) {
        switch (mode) {
            case READ: {
                this.activeReadTxn.decrementAndGet();
                break;
            }
            case WRITE: {
                this.activeWriteTxn.decrementAndGet();
            }
        }
        this.checkShutdown();
    }

    private void checkShutdown() {
        if (this.state == DatasetStatus.CLOSING && this.activeReadTxn.get() == 0L && this.activeWriteTxn.get() == 0L) {
            this.shutdown();
        }
    }

    private void shutdown() {
        Fuseki.serverLog.info("Shutting down dataset");
        this.dataset.close();
        if (this.dataset instanceof DatasetGraphTransaction) {
            DatasetGraphTransaction dsgtxn = (DatasetGraphTransaction)this.dataset;
            StoreConnection.release((Location)dsgtxn.getLocation());
        }
        this.dataset = null;
    }

    static {
        DatasetGraphReadOnly dsg = new DatasetGraphReadOnly(DatasetGraphFactory.create());
        dummy = new DataService((DatasetGraph)dsg);
        dummy.addEndpoint(Operation.Query, "query");
        dummy.addEndpoint(Operation.Query, "sparql");
    }
}

