/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Objects;
import org.apache.jena.fuseki.server.NameMgr;

public class CounterName {
    private static NameMgr<CounterName> mgr = new NameMgr();
    private final String name;
    private final String hierarchicalName;
    public static final CounterName Requests = CounterName.register("Requests", "requests");
    public static final CounterName RequestsGood = CounterName.register("RequestsGood", "requests.good");
    public static final CounterName RequestsBad = CounterName.register("RequestsBad", "requests.bad");
    public static final CounterName QueryTimeouts = CounterName.register("QueryTimeouts", "query.timeouts");
    public static final CounterName QueryExecErrors = CounterName.register("QueryExecErrors", "query.execerrors");
    public static final CounterName QueryIOErrors = CounterName.register("QueryIOErrors", "query.ioerrors");
    public static final CounterName UpdateExecErrors = CounterName.register("UpdateExecErrors", "update.execerrors");
    public static final CounterName HTTPget = CounterName.register("HTTPget", "http.get.requests");
    public static final CounterName HTTPgetGood = CounterName.register("HTTPgetGood", "http.get.requests.good");
    public static final CounterName HTTPgetBad = CounterName.register("HTTPGetBad", "http.get.requests.bad");
    public static final CounterName HTTPpost = CounterName.register("HTTPpost", "http.post.requests");
    public static final CounterName HTTPpostGood = CounterName.register("HTTPpostGood", "http.post.requests.good");
    public static final CounterName HTTPpostBad = CounterName.register("HTTPpostBad", "http.post.requests.bad");
    public static final CounterName HTTPdelete = CounterName.register("HTTPdelete", "http.delete.requests");
    public static final CounterName HTTPdeleteGood = CounterName.register("HTTPdeleteGood", "http.delete.requests.good");
    public static final CounterName HTTPdeleteBad = CounterName.register("HTTPdeleteBad", "http.delete.requests.bad");
    public static final CounterName HTTPput = CounterName.register("HTTPput", "http.put.requests");
    public static final CounterName HTTPputGood = CounterName.register("HTTPputGood", "http.put.requests.good");
    public static final CounterName HTTPputBad = CounterName.register("HTTPputBad", "http.put.requests.bad");
    public static final CounterName HTTPhead = CounterName.register("HTTPhead", "http.head.requests");
    public static final CounterName HTTPheadGood = CounterName.register("HTTPheadGood", "http.head.requests.good");
    public static final CounterName HTTPheadBad = CounterName.register("HTTPheadBad", "http.head.requests.bad");
    public static final CounterName HTTPpatch = CounterName.register("HTTPpatch", "http.patch.requests");
    public static final CounterName HTTPpatchGood = CounterName.register("HTTPpatchGood", "http.patch.requests.good");
    public static final CounterName HTTPpatchBad = CounterName.register("HTTPpatchBad", "http.patch.requests.bad");
    public static final CounterName HTTPoptions = CounterName.register("HTTPoptions", "http.options.requests");
    public static final CounterName HTTPoptionsGood = CounterName.register("HTTPoptionsGood", "http.options.requests.good");
    public static final CounterName HTTPoptionsBad = CounterName.register("HTTPoptionsBad", "http.options.requests.bad");

    public static CounterName register(String name, String hierarchicalName) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(hierarchicalName, "hierarchicalName");
        return mgr.register(name, n -> new CounterName(name, hierarchicalName));
    }

    private CounterName(String name, String hierarchicalName) {
        this.name = name;
        this.hierarchicalName = hierarchicalName;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.hierarchicalName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CounterName other = (CounterName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

