/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.migrate;

import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.migrate.StreamRDFLimited;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class GraphLoadUtils {
    public static Model readModel(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return ModelFactory.createModelForGraph((Graph)g);
    }

    public static void loadModel(Model model, String uri, int limit) {
        Graph g = model.getGraph();
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    public static Graph readGraph(String uri, int limit) {
        Graph g = Factory.createGraphMem();
        GraphLoadUtils.readUtil(g, uri, limit);
        return g;
    }

    public static void loadGraph(Graph g, String uri, int limit) {
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    private static void readUtil(Graph graph, String uri, int limit) {
        Object sink = StreamRDFLib.graph((Graph)graph);
        sink = new StreamRDFLimited((StreamRDF)sink, limit);
        RDFParser.source((String)uri).streamManager(Fuseki.webStreamManager).parse(sink);
    }
}

