/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.mgt.ActionCtl;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public abstract class ActionContainerItem
extends ActionCtl {
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected final void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    protected final void doDelete(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected final void perform(HttpAction action) {
        String method = action.request.getMethod();
        if (method.equals("GET")) {
            this.execGet(action);
        } else if (method.equals("POST")) {
            this.execPost(action);
        } else if (method.equals("DELETE")) {
            this.execDelete(action);
        } else {
            ServletOps.error(405);
        }
    }

    protected void execGet(HttpAction action) {
        JsonValue v = this.isContainerAction(action) ? this.execGetContainer(action) : this.execGetItem(action);
        ServletOps.sendJsonReponse(action, v);
    }

    protected abstract JsonValue execGetContainer(HttpAction var1);

    protected abstract JsonValue execGetItem(HttpAction var1);

    protected void execPost(HttpAction action) {
        JsonValue v = this.isContainerAction(action) ? this.execPostContainer(action) : this.execPostItem(action);
        ServletOps.sendJsonReponse(action, v);
    }

    protected abstract JsonValue execPostContainer(HttpAction var1);

    protected abstract JsonValue execPostItem(HttpAction var1);

    protected void execDelete(HttpAction action) {
        if (this.isContainerAction(action)) {
            this.execDeleteContainer(action);
        } else {
            this.execDeleteItem(action);
        }
        ServletOps.success(action);
    }

    protected void execDeleteContainer(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE", "DELETE applied to a container");
    }

    protected void execDeleteItem(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE");
    }
}

