/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RefCountingMap<K, T> {
    protected Map<K, CountedRef<T>> map = new ConcurrentHashMap<K, CountedRef<T>>();

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public Collection<K> keys() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public void add(K key, T value) {
        this.map.compute(key, (k, v) -> {
            int refCount = 1;
            if (v != null && v.getRef().equals(value)) {
                refCount = v.getCount() + 1;
            }
            return new CountedRef<Object>(value, refCount);
        });
    }

    public void remove(K key) {
        this.map.compute(key, (k, v) -> {
            if (v == null) {
                return null;
            }
            int refCount = v.getCount() - 1;
            if (refCount == 0) {
                return null;
            }
            return new CountedRef(v.getRef(), refCount);
        });
    }

    public void removeAll(K key) {
        this.map.remove(key);
    }

    public int refCount(K key) {
        CountedRef<T> ref = this.map.get(key);
        if (ref == null) {
            return 0;
        }
        return ref.getCount();
    }

    public T get(Object key) {
        CountedRef<T> ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        return ref.getRef();
    }

    class CountedRef<R> {
        final int refCount;
        final R ref;

        CountedRef(R ref, int refCount) {
            this.refCount = refCount;
            this.ref = ref;
        }

        int getCount() {
            return this.refCount;
        }

        R getRef() {
            return this.ref;
        }
    }
}

