/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.build.RefCountingMap;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Resource;

public class DatasetDescriptionRegistry {
    private RefCountingMap<Resource, Dataset> map = new RefCountingMap();

    public void register(Resource node, Dataset ds) {
        Dataset dsCurrent = this.map.get(node);
        if (dsCurrent != null && !dsCurrent.equals(ds)) {
            Log.warn(this.getClass(), (String)("Replacing registered dataset for " + node));
        }
        this.map.add(node, ds);
    }

    public void unregister(Resource node) {
        this.map.remove(node);
    }

    public int refCount(Resource node) {
        return this.map.refCount(node);
    }

    public Dataset get(Resource node) {
        return this.map.get(node);
    }

    public void clear() {
        this.map.clear();
    }
}

