/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import java.io.File;
import java.net.URL;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;

public class FusekiLogging {
    private static final String[] resourcesForLog4jProperties = new String[]{"log4j.properties", "org/apache/jena/fuseki/log4j.properties"};
    private static final boolean LogLogging = false;
    private static boolean loggingInitialized = false;
    private static boolean allowLoggingReset = true;

    public static synchronized void allowLoggingReset(boolean value) {
        allowLoggingReset = value;
    }

    public static synchronized void setLogging() {
        if (!allowLoggingReset) {
            return;
        }
        if (loggingInitialized) {
            return;
        }
        loggingInitialized = true;
        FusekiEnv.setEnvironment();
        FusekiLogging.logLogging("Fuseki logging", new Object[0]);
        String x = System.getProperty("log4j.configuration", null);
        FusekiLogging.logLogging("log4j.configuration = %s", x);
        if (x != null) {
            if (x.equals("set")) {
                Fuseki.serverLog.warn("Fuseki logging: Unexpected: Log4j was setup by some other part of Jena");
            }
            return;
        }
        FusekiLogging.logLogging("Fuseki logging - setup", new Object[0]);
        String fn1 = "log4j.properties";
        String fn2 = null;
        if (FusekiEnv.FUSEKI_BASE != null) {
            fn2 = FusekiEnv.FUSEKI_BASE.toString() + "/log4j.properties";
        }
        if (FusekiLogging.attempt(fn1)) {
            return;
        }
        if (FusekiLogging.attempt(fn2)) {
            return;
        }
        for (String resourceName : resourcesForLog4jProperties) {
            FusekiLogging.logLogging("Fuseki logging - classpath %s", resourceName);
            URL url = Loader.getResource((String)resourceName);
            if (url != null && (url.toString().contains("-tests.jar") || url.toString().contains("test-classes"))) {
                url = null;
            }
            if (url == null) continue;
            PropertyConfigurator.configure((URL)url);
            FusekiLogging.logLogging("Fuseki logging - found via classpath %s", url);
            System.setProperty("log4j.configuration", url.toString());
            return;
        }
        FusekiLogging.logLogging("Fuseki logging - Fallback log4j.properties string", new Object[0]);
        String dftLog4j = FusekiLogging.log4JsetupFallback();
        LogCtl.resetLogging((String)dftLog4j);
        System.setProperty("log4j.configuration", "set");
    }

    private static boolean attempt(String fn) {
        try {
            File f = new File(fn);
            if (f.exists()) {
                FusekiLogging.logLogging("Fuseki logging - found file:log4j.properties", new Object[0]);
                PropertyConfigurator.configure((String)fn);
                System.setProperty("log4j.configuration", "file:" + fn);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void logLogging(String fmt, Object ... args) {
    }

    private static String log4JsetupFallback() {
        return StrUtils.strjoinNL((String[])new String[]{"## Plain output to stdout", "log4j.appender.jena.plainstdout=org.apache.log4j.ConsoleAppender", "log4j.appender.jena.plainstdout.target=System.out", "log4j.appender.jena.plainstdout.layout=org.apache.log4j.PatternLayout", "log4j.appender.jena.plainstdout.layout.ConversionPattern=[%d{yyyy-MM-dd HH:mm:ss}] %-10c{1} %-5p %m%n", "# Unadorned, for the requests log.", "log4j.appender.fuseki.plain=org.apache.log4j.ConsoleAppender", "log4j.appender.fuseki.plain.target=System.out", "log4j.appender.fuseki.plain.layout=org.apache.log4j.PatternLayout", "log4j.appender.fuseki.plain.layout.ConversionPattern=%m%n", "## Most things", "log4j.rootLogger=INFO, jena.plainstdout", "log4j.logger.com.hp.hpl.jena=WARN", "log4j.logger.org.apache.jena=WARN", "# Fuseki System logs.", "log4j.logger." + Fuseki.serverLogName + "=INFO", "log4j.logger." + Fuseki.actionLogName + "=INFO", "log4j.logger." + Fuseki.adminLogName + "=INFO", "log4j.logger." + Fuseki.validationLogName + "=INFO", "log4j.logger." + Fuseki.configLogName + "=INFO", "log4j.logger.org.apache.jena.tdb.loader=INFO", "log4j.logger.org.eclipse.jetty=WARN", "log4j.logger.org.apache.shiro=WARN", "# NCSA Request Access log", "log4j.additivity." + Fuseki.requestLogName + "=false", "log4j.logger." + Fuseki.requestLogName + "=OFF, fuseki.plain", "## Parser output", "log4j.additivityorg.apache.jena.riot=false", "log4j.logger.org.apache.jena.riot=INFO, plainstdout"});
    }
}

