/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.SystemState;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Convert;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;

public class FusekiLib {
    public static ContentType getContentType(HttpAction action) {
        return FusekiLib.getContentType(action.request);
    }

    public static ContentType getContentType(HttpServletRequest request) {
        String contentTypeHeader = request.getContentType();
        if (contentTypeHeader == null) {
            return null;
        }
        return ContentType.create((String)contentTypeHeader);
    }

    public static Lang getLangFromAction(HttpAction action, Lang dft) {
        String contentTypeHeader = action.request.getContentType();
        if (contentTypeHeader == null) {
            return dft;
        }
        return RDFLanguages.contentTypeToLang((String)contentTypeHeader);
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm((StringBuffer)request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm((String)tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static Multimap<String, String> parseQueryString(HttpServletRequest req) {
        ArrayListMultimap map = ArrayListMultimap.create();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put((Object)name, (Object)value);
            }
        }
        return map;
    }

    public static String safeParameter(HttpServletRequest request, String pName) {
        String value = request.getParameter(pName);
        if (value == null) {
            return null;
        }
        value = value.replace("\r", "");
        value = value.replace("\n", "");
        return value;
    }

    public static void addDataInto(Graph data, DatasetGraph dsg, Node graphName) {
        if (graphName == null) {
            graphName = Quad.defaultGraphNodeGenerated;
        }
        ExtendedIterator iter = data.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            dsg.add(graphName, t.getSubject(), t.getPredicate(), t.getObject());
        }
        PrefixMapping pmapSrc = data.getPrefixMapping();
        PrefixMapping pmapDest = dsg.getDefaultGraph().getPrefixMapping();
        pmapDest.setNsPrefixes(pmapSrc);
    }

    public static void addDataInto(DatasetGraph src, DatasetGraph dest) {
        Iterator iter = src.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Quad q = (Quad)iter.next();
            dest.add(q);
        }
        PrefixMapping pmapSrc = src.getDefaultGraph().getPrefixMapping();
        PrefixMapping pmapDest = dest.getDefaultGraph().getPrefixMapping();
        pmapDest.withDefaultMappings(pmapSrc);
    }

    public static ResultSet query(String string, Model m) {
        return FusekiLib.query(string, m, null, null);
    }

    public static ResultSet query(String string, Dataset ds) {
        return FusekiLib.query(string, ds, null, null);
    }

    public static ResultSet query(String string, Model m, String varName, RDFNode value) {
        Query query = QueryFactory.create((String)(SystemState.PREFIXES + string));
        QuerySolutionMap initValues = null;
        if (varName != null) {
            initValues = FusekiLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)m, (QuerySolution)initValues);){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults((ResultSet)qExec.execSelect());
            return resultSetRewindable;
        }
    }

    public static ResultSet query(String string, Dataset ds, String varName, RDFNode value) {
        Query query = QueryFactory.create((String)(SystemState.PREFIXES + string));
        QuerySolutionMap initValues = null;
        if (varName != null) {
            initValues = FusekiLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds, (QuerySolution)initValues);){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults((ResultSet)qExec.execSelect());
            return resultSetRewindable;
        }
    }

    private static QuerySolutionMap querySolution(String varName, RDFNode value) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        FusekiLib.querySolution(qsm, varName, value);
        return qsm;
    }

    public static QuerySolutionMap querySolution(QuerySolutionMap qsm, String varName, RDFNode value) {
        qsm.add(varName, value);
        return qsm;
    }

    public static RDFNode getOne(Resource svc, String property) {
        ResultSet rs = FusekiLib.query("SELECT * { ?svc " + property + " ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No property '" + property + "' for service " + FusekiLib.nodeLabel((RDFNode)svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple properties '" + property + "' for service " + FusekiLib.nodeLabel((RDFNode)svc));
        }
        return x;
    }

    public static String nodeLabel(RDFNode n) {
        if (n == null) {
            return "<null>";
        }
        if (n instanceof Resource) {
            return FusekiLib.strForResource((Resource)n);
        }
        Literal lit = (Literal)n;
        return lit.getLexicalForm();
    }

    public static String strForResource(Resource r) {
        return FusekiLib.strForResource(r, (PrefixMapping)r.getModel());
    }

    public static String strForResource(Resource r, PrefixMapping pm) {
        RDFNode n;
        if (r == null) {
            return "NULL ";
        }
        if (r.hasProperty(RDFS.label) && (n = r.getProperty(RDFS.label).getObject()) instanceof Literal) {
            return ((Literal)n).getString();
        }
        if (r.isAnon()) {
            return "<<blank node>>";
        }
        if (pm == null) {
            pm = r.getModel();
        }
        return FusekiLib.strForURI(r.getURI(), pm);
    }

    public static String strForURI(String uri, PrefixMapping pm) {
        String x;
        if (pm != null && !(x = pm.shortForm(uri)).equals(uri)) {
            return x;
        }
        return "<" + uri + ">";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int choosePort() {
        try (ServerSocket s = new ServerSocket(0);){
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException ex) {
            throw new FusekiException("Failed to find a port");
        }
    }

    public static boolean isFuseki(String datasetURL) {
        HttpOptions request = new HttpOptions(datasetURL);
        HttpClient httpClient = HttpOp.getDefaultHttpClient();
        if (httpClient == null) {
            httpClient = HttpClients.createSystem();
        }
        return FusekiLib.isFuseki(request, httpClient, null);
    }

    public static boolean isFuseki(RDFConnectionRemote connection) {
        HttpOptions request = new HttpOptions(connection.getDestination());
        HttpClient httpClient = connection.getHttpClient();
        if (httpClient == null) {
            httpClient = HttpClients.createSystem();
        }
        HttpContext httpContext = connection.getHttpContext();
        return FusekiLib.isFuseki(request, httpClient, httpContext);
    }

    private static boolean isFuseki(HttpOptions request, HttpClient httpClient, HttpContext httpContext) {
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            String reqId = FusekiLib.safeGetHeader(response, "Fuseki-Request-ID");
            if (reqId != null) {
                return true;
            }
            String serverIdent = FusekiLib.safeGetHeader(response, "Server");
            if (serverIdent != null) {
                Log.debug((Object)ARQ.getHttpRequestLogger(), (String)("Server: " + serverIdent));
                boolean isFuseki = serverIdent.startsWith("Apache Jena Fuseki");
                if (!isFuseki) {
                    isFuseki = serverIdent.toLowerCase().contains("fuseki");
                }
                return isFuseki;
            }
            return false;
        }
        catch (IOException ex) {
            throw new HttpException("Failed to check for a Fuseki server", (Throwable)ex);
        }
    }

    private static String safeGetHeader(HttpResponse response, String header) {
        Header h = response.getFirstHeader(header);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }
}

