/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.fuseki.validation.json.ValidatorJsonLib;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.riot.system.IRIResolver;

public class IRIValidatorJSON {
    static IRIFactory iriFactory = IRIResolver.iriFactory();
    static final String paramIRI = "iri";
    static final String jIRIs = "iris";
    static final String jIRI = "iri";

    public static JsonObject execute(ValidationAction action) {
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String[] args = ValidatorJsonLib.getArgs(action, "iri");
        if (args.length == 0) {
            ServletOps.errorBadRequest("No IRIs supplied");
        }
        obj.key(jIRIs);
        obj.startArray();
        for (String iriStr : args) {
            obj.startObject();
            obj.key("iri").value(iriStr);
            IRI iri = iriFactory.create(iriStr);
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            if (iri.isRelative()) {
                warnings.add("Relative IRI: " + iriStr);
            }
            Iterator vIter = iri.violations(true);
            while (vIter.hasNext()) {
                Violation v = (Violation)vIter.next();
                String str = v.getShortMessage();
                if (v.isError()) {
                    errors.add(str);
                    continue;
                }
                warnings.add(str);
            }
            obj.key("errors");
            obj.startArray();
            for (String msg : errors) {
                obj.value(msg);
            }
            obj.finishArray();
            obj.key("warning");
            obj.startArray();
            for (String msg : warnings) {
                obj.value(msg);
            }
            obj.finishArray();
            obj.finishObject();
        }
        obj.finishArray();
        obj.finishObject();
        return obj.build().getAsObject();
    }
}

