/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.fuseki.validation.html.ValidatorHtmlLib;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateValidatorHTML {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramUpdate = "update";
    static final String paramSyntax = "languageSyntax";

    public static void executeHTML(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Syntax language;
            String[] args = httpRequest.getParameterValues(paramUpdate);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No update parameter to validator");
                return;
            }
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many update parameters");
                return;
            }
            String updateString = httpRequest.getParameter(paramUpdate).replaceAll("(\r|\n| )*$", "");
            String updateSyntax = httpRequest.getParameter(paramSyntax);
            if (updateSyntax == null || updateSyntax.equals("")) {
                updateSyntax = "SPARQL";
            }
            if ((language = Syntax.lookup((String)updateSyntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + updateSyntax);
                return;
            }
            String lineNumbersArg = httpRequest.getParameter(paramLineNumbers);
            String[] a = httpRequest.getParameterValues(paramFormat);
            boolean outputSPARQL = true;
            boolean lineNumbers = true;
            if (lineNumbersArg != null) {
                lineNumbers = lineNumbersArg.equalsIgnoreCase("true") || lineNumbersArg.equalsIgnoreCase("yes");
            }
            ValidatorHtmlLib.setHeaders(httpResponse);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            outStream.println("<html>");
            ValidatorHtmlLib.printHead(outStream, "SPARQL Update Validation Report");
            outStream.println("<body>");
            outStream.println("<h1>SPARQL Update Validator</h1>");
            outStream.println("<p>Input:</p>");
            ValidatorHtmlLib.output(outStream, out -> out.print(updateString), lineNumbers);
            UpdateRequest request = null;
            try {
                request = UpdateFactory.create((String)updateString, (String)"http://example/base/", (Syntax)language);
            }
            catch (ARQException ex) {
                outStream.println("<p>Syntax error:</p>");
                ValidatorHtmlLib.startFixed(outStream);
                outStream.println(ex.getMessage());
                ValidatorHtmlLib.finishFixed(outStream);
            }
            catch (RuntimeException ex) {
                outStream.println("<p>Internal error:</p>");
                ValidatorHtmlLib.startFixed(outStream);
                outStream.println(ex.getMessage());
                ValidatorHtmlLib.finishFixed(outStream);
            }
            UpdateRequest updateRequest = request;
            if (updateRequest != null && outputSPARQL) {
                outStream.println("<p>Formatted, parsed update request:</p>");
                ValidatorHtmlLib.output(outStream, out -> updateRequest.output((IndentedWriter)out), lineNumbers);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (Exception ex) {
            ValidatorHtmlLib.serviceLog.warn("Exception in doGet", (Throwable)ex);
        }
    }
}

