/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.validation.html.ValidatorHtmlLib;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.riot.system.IRIResolver;

public class IRIValidatorHTML {
    static final String paramIRI = "iri";
    static IRIFactory iriFactory = IRIResolver.iriFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeHTML(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String[] args = httpRequest.getParameterValues(paramIRI);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No ?iri= parameter");
            }
            ServletOutputStream outStream = httpResponse.getOutputStream();
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(new PrintStream((OutputStream)outStream));
            System.setErr(new PrintStream((OutputStream)outStream));
            ValidatorHtmlLib.setHeaders(httpResponse);
            outStream.println("<html>");
            ValidatorHtmlLib.printHead(outStream, "Jena IRI Validator Report");
            outStream.println("<body>");
            outStream.println("<h1>IRI Report</h1>");
            ValidatorHtmlLib.startFixed(outStream);
            try {
                boolean first = true;
                for (String iriStr : args) {
                    if (!first) {
                        System.out.println();
                    }
                    first = false;
                    IRI iri = iriFactory.create(iriStr);
                    System.out.println(iriStr + " ==> " + iri);
                    if (iri.isRelative()) {
                        System.out.println("Relative IRI: " + iriStr);
                    }
                    Iterator vIter = iri.violations(true);
                    while (vIter.hasNext()) {
                        String str = ((Violation)vIter.next()).getShortMessage();
                        str = ValidatorHtmlLib.htmlQuote(str);
                        System.out.println(str);
                    }
                }
            }
            finally {
                ValidatorHtmlLib.finishFixed(outStream);
                System.out.flush();
                System.err.flush();
                System.setOut(stdout);
                System.setErr(stdout);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

