/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.FusekiLib;
import org.apache.jena.fuseki.conneg.ConNeg;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_GSP;
import org.apache.jena.fuseki.servlets.SPARQL_GSP_R;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.Upload;
import org.apache.jena.fuseki.servlets.UploadDetails;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.graph.GraphFactory;

public class SPARQL_GSP_RW
extends SPARQL_GSP_R {
    @Override
    protected void doOptions(HttpAction action) {
        SPARQL_GSP_RW.setCommonHeadersForOptions((HttpServletResponse)action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,DELETE,POST");
        action.response.setHeader("Content-Length", "0");
        ServletOps.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(HttpAction action) {
        action.beginWrite();
        try {
            boolean existedBefore;
            SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("DELETE->" + target);
            }
            if (!(existedBefore = target.exists())) {
                action.commit();
                ServletOps.errorNotFound("No such graph: " + target.name);
            }
            SPARQL_GSP_RW.deleteGraph(action);
            action.commit();
        }
        finally {
            action.endWrite();
        }
        ServletOps.successNoContent(action);
    }

    @Override
    protected void doPut(HttpAction action) {
        this.doPutPost(action, true);
    }

    @Override
    protected void doPost(HttpAction action) {
        this.doPutPost(action, false);
    }

    private void doPutPost(HttpAction action, boolean overwrite) {
        ContentType ct = FusekiLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No Content-Type:");
        }
        if (WebContent.matchContentType((ContentType)WebContent.ctMultipartMixed, (ContentType)ct)) {
            ServletOps.error(415, "multipart/mixed not supported");
        }
        UploadDetails details = action.isTransactional() ? SPARQL_GSP_RW.addDataIntoTxn(action, overwrite) : SPARQL_GSP_RW.addDataIntoNonTxn(action, overwrite);
        MediaType mt = ConNeg.chooseCharset(action.request, DEF.jsonOffer, DEF.acceptJSON);
        if (mt == null) {
            if (details.getExistedBefore().equals((Object)UploadDetails.PreState.ABSENT)) {
                ServletOps.successCreated(action);
            } else {
                ServletOps.successNoContent(action);
            }
            return;
        }
        ServletOps.uploadResponse(action, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UploadDetails addDataIntoTxn(HttpAction action, boolean overwrite) {
        action.beginWrite();
        try {
            SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(action);
            if (action.log.isDebugEnabled()) {
                action.log.debug(action.request.getMethod().toUpperCase() + "->" + target);
            }
            boolean existedBefore = target.exists();
            Graph g = target.graph();
            if (overwrite && existedBefore) {
                SPARQL_GSP_RW.clearGraph(target);
            }
            StreamRDF sink = StreamRDFLib.graph((Graph)g);
            UploadDetails upload = Upload.incomingData(action, sink);
            upload.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = upload;
            return uploadDetails;
        }
        catch (ActionErrorException ex) {
            action.abort();
            throw ex;
        }
        catch (RiotException ex) {
            action.abort();
            ServletOps.errorBadRequest(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        catch (Exception ex) {
            action.abort();
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static UploadDetails addDataIntoNonTxn(HttpAction action, boolean overwrite) {
        UploadDetails details;
        Graph graphTmp = GraphFactory.createGraphMem();
        StreamRDF dest = StreamRDFLib.graph((Graph)graphTmp);
        try {
            details = Upload.incomingData(action, dest);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest(ex.getMessage());
            return null;
        }
        action.beginWrite();
        SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(action);
        boolean existedBefore = false;
        try {
            if (action.log.isDebugEnabled()) {
                action.log.debug("  ->" + target);
            }
            existedBefore = target.exists();
            if (overwrite && existedBefore) {
                SPARQL_GSP_RW.clearGraph(target);
            }
            FusekiLib.addDataInto(graphTmp, target.dsg, target.graphName);
            details.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = details;
            return uploadDetails;
        }
        catch (Exception ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.endWrite();
        }
    }

    protected static void deleteGraph(HttpAction action) {
        SPARQL_GSP.Target target = SPARQL_GSP_RW.determineTarget(action);
        if (target.isDefault) {
            SPARQL_GSP_RW.clearGraph(target);
        } else {
            action.getActiveDSG().removeGraph(target.graphName);
        }
    }

    protected static void clearGraph(SPARQL_GSP.Target target) {
        Graph g = target.graph();
        g.getPrefixMapping().clearNsPrefixMap();
        g.clear();
    }
}

