/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionBase;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.QueryCancelledException;

public abstract class ActionService
extends ActionBase {
    protected ActionService() {
        super(Fuseki.actionLog);
    }

    protected abstract void validate(HttpAction var1);

    protected abstract void perform(HttpAction var1);

    @Override
    protected void execCommonWorker(HttpAction action) {
        ActionService handler;
        DataService dSrv;
        DataAccessPoint dataAccessPoint;
        String datasetUri = this.mapRequestToDataset(action);
        if (datasetUri != null) {
            dataAccessPoint = (DataAccessPoint)action.getDataAccessPointRegistry().get(datasetUri);
            if (dataAccessPoint == null) {
                ServletOps.errorNotFound("No dataset for URI: " + datasetUri);
                return;
            }
            dSrv = dataAccessPoint.getDataService();
            if (!dSrv.isAcceptingRequests()) {
                ServletOps.error(503, "Dataset not currently active");
                return;
            }
        } else {
            dataAccessPoint = null;
            dSrv = DataService.serviceOnlyDataService();
        }
        action.setRequest(dataAccessPoint, dSrv);
        String endpointName = this.mapRequestToOperation(action, dataAccessPoint);
        Operation operation = null;
        if (!endpointName.isEmpty()) {
            operation = this.chooseOperation(action, dSrv, endpointName);
            if (operation == null) {
                ServletOps.errorNotFound(String.format("dataset=%s, service=%s", dataAccessPoint.getName(), endpointName));
            }
        } else {
            operation = this.chooseOperation(action, dSrv);
            if (operation == null) {
                ServletOps.errorBadRequest(String.format("dataset=%s", dataAccessPoint.getName()));
            }
        }
        if ((handler = action.getServiceDispatchRegistry().findHandler(operation)) == null) {
            ServletOps.errorBadRequest(String.format("dataset=%s: op=%s", dataAccessPoint.getName(), operation.getName()));
        }
        Endpoint ep = dSrv.getEndpoint(endpointName);
        action.setEndpoint(ep, endpointName);
        handler.executeLifecycle(action);
    }

    protected Operation chooseOperation(HttpAction action, DataService dataService, String serviceName) {
        Endpoint ep = dataService.getEndpoint(serviceName);
        Operation operation = ep.getOperation();
        return operation;
    }

    protected Operation chooseOperation(HttpAction action, DataService dataService) {
        return null;
    }

    private void executeRequest(HttpAction action, ActionService servlet) {
        servlet.executeLifecycle(action);
    }

    protected void executeAction(HttpAction action) {
        this.executeLifecycle(action);
    }

    protected final void executeLifecycle(HttpAction action) {
        CounterSet csService = action.getDataService().getCounters();
        CounterSet csOperation = null;
        if (action.getEndpoint() != null) {
            csOperation = action.getEndpoint().getCounters();
        }
        ActionService.incCounter(csService, CounterName.Requests);
        ActionService.incCounter(csOperation, CounterName.Requests);
        try {
            this.validate(action);
        }
        catch (ActionErrorException ex) {
            ActionService.incCounter(csOperation, CounterName.RequestsBad);
            ActionService.incCounter(csService, CounterName.RequestsBad);
            throw ex;
        }
        try {
            this.perform(action);
            ActionService.incCounter(csOperation, CounterName.RequestsGood);
            ActionService.incCounter(csService, CounterName.RequestsGood);
        }
        catch (RuntimeIOException | ActionErrorException | QueryCancelledException ex) {
            ActionService.incCounter(csOperation, CounterName.RequestsBad);
            ActionService.incCounter(csService, CounterName.RequestsBad);
            throw ex;
        }
    }

    protected String mapRequestToDataset(HttpAction action) {
        return ActionLib.mapRequestToDataset(action);
    }

    protected String mapRequestToOperation(HttpAction action, DataAccessPoint dataAccessPoint) {
        return ActionLib.mapRequestToOperation(action, dataAccessPoint);
    }

    protected static void incCounter(Counters counters, CounterName name) {
        if (counters == null) {
            return;
        }
        ActionService.incCounter(counters.getCounters(), name);
    }

    protected static void decCounter(Counters counters, CounterName name) {
        if (counters == null) {
            return;
        }
        ActionService.decCounter(counters.getCounters(), name);
    }

    protected static void incCounter(CounterSet counters, CounterName name) {
        if (counters == null) {
            return;
        }
        try {
            if (counters.contains(name)) {
                counters.inc(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter inc", (Throwable)ex);
        }
    }

    protected static void decCounter(CounterSet counters, CounterName name) {
        if (counters == null) {
            return;
        }
        try {
            if (counters.contains(name)) {
                counters.dec(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter dec", (Throwable)ex);
        }
    }
}

