/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.apache.jena.fuseki.server.FusekiSystem;
import org.apache.jena.util.FileUtils;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.web.env.EnvironmentLoader;
import org.apache.shiro.web.env.ResourceBasedWebEnvironment;
import org.apache.shiro.web.env.WebEnvironment;

public class ShiroEnvironmentLoader
extends EnvironmentLoader
implements ServletContextListener {
    private ServletContext servletContext;
    private static final String FILE = "file";

    public void contextInitialized(ServletContextEvent sce) {
        FusekiSystem.formatBaseArea();
        this.servletContext = sce.getServletContext();
        try {
            this.initEnvironment(this.servletContext);
        }
        catch (ConfigurationException ex) {
            Fuseki.configLog.error("Shiro initialization failed: " + ex.getMessage());
            throw ex;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.destroyEnvironment(sce.getServletContext());
    }

    protected void customizeEnvironment(WebEnvironment environment) {
        if (environment instanceof ResourceBasedWebEnvironment) {
            ResourceBasedWebEnvironment env = (ResourceBasedWebEnvironment)environment;
            String[] locations = env.getConfigLocations();
            String loc = ShiroEnvironmentLoader.huntForShiroIni(locations);
            Fuseki.configLog.info("Shiro file: " + loc);
            if (loc != null) {
                locations = new String[]{loc};
            }
            env.setConfigLocations(locations);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String huntForShiroIni(String[] locations) {
        FusekiEnv.setEnvironment();
        Fuseki.init();
        String[] stringArray = locations;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path p;
            String loc = stringArray[n2];
            String scheme = FileUtils.getScheme((String)loc);
            if (scheme != null) {
                if (!scheme.equalsIgnoreCase(FILE)) return loc;
                p = Paths.get(loc.substring(FILE.length() + 1), new String[0]);
                if (p.toFile().exists()) return loc;
            } else {
                p = Paths.get(loc, new String[0]);
                String fn = ShiroEnvironmentLoader.resolve(FusekiEnv.FUSEKI_BASE, p);
                if (fn != null) {
                    return "file://" + fn;
                }
                fn = ShiroEnvironmentLoader.resolve(FusekiEnv.FUSEKI_HOME, p);
                if (fn != null) {
                    return "file://" + fn;
                }
                try (InputStream is = ResourceUtils.getInputStreamForPath((String)loc);){
                    boolean exists = is != null;
                    String string = loc;
                    return string;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return null;
    }

    private static String resolve(Path dir, Path file) {
        Path p = dir.resolve(file);
        if (p.toFile().exists()) {
            return p.normalize().toString();
        }
        return null;
    }
}

