/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.Operation;

public class Endpoint
implements Counters {
    public final Operation operation;
    public final String endpointName;
    private final CounterSet counters = new CounterSet();

    public Endpoint(Operation operation, String endpointName) {
        this.operation = operation;
        if (operation == null) {
            throw new InternalErrorException("operation is null");
        }
        this.endpointName = endpointName;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    @Override
    public CounterSet getCounters() {
        return this.counters;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isType(Operation operation) {
        return operation.equals(operation);
    }

    public String getEndpoint() {
        return this.endpointName;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }
}

