/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import javax.servlet.ServletContext;
import org.apache.jena.atlas.lib.Registry;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.Operation;

public class DataAccessPointRegistry
extends Registry<String, DataAccessPoint> {
    private static final String attrNameRegistry = "jena-fuseki:dataAccessPointRegistry";

    public DataAccessPointRegistry() {
    }

    public DataAccessPointRegistry(DataAccessPointRegistry other) {
        other.forEach((name, accessPoint) -> this.register((String)name, (DataAccessPoint)accessPoint));
    }

    public void register(String name, DataAccessPoint accessPt) {
        if (this.isRegistered(name)) {
            throw new FusekiException("Already registered: " + name);
        }
        super.put((Object)name, (Object)accessPt);
    }

    public void print(String string) {
        System.out.flush();
        if (string == null) {
            string = "DataAccessPointRegistry";
        }
        System.out.println("== " + string);
        this.forEach((k, ref) -> {
            System.out.printf("  (key=%s, ref=%s)\n", k, ref.getName());
            ref.getDataService().getOperations().forEach(op -> ref.getDataService().getEndpoints((Operation)op).forEach(ep -> System.out.printf("     %s : %s\n", op, ep.getEndpoint())));
        });
    }

    public static DataAccessPointRegistry get(ServletContext cxt) {
        DataAccessPointRegistry registry = (DataAccessPointRegistry)((Object)cxt.getAttribute(attrNameRegistry));
        if (registry == null) {
            Log.warn(DataAccessPointRegistry.class, (String)"No data access point registry for ServletContext");
        }
        return registry;
    }

    public static void set(ServletContext cxt, DataAccessPointRegistry registry) {
        cxt.setAttribute(attrNameRegistry, (Object)registry);
    }
}

