/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.jetty;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.BindException;
import javax.servlet.ServletContext;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.jetty.FusekiErrorHandler;
import org.apache.jena.fuseki.jetty.JettyServerConfig;
import org.apache.jena.fuseki.mgt.MgtJMX;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiEnv;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyFuseki {
    public static JettyFuseki instance;
    private ServerConnector serverConnector = null;
    private ServerConnector mgtConnector = null;
    private JettyServerConfig serverConfig;
    private Server server = null;
    private ServletContext servletContext = null;
    public static String contextpath;
    public static final String resourceBase1 = "webapp";
    public static final String resourceBase2 = "src/main/webapp";

    public static void initializeServer(JettyServerConfig config) {
        instance = new JettyFuseki(config);
    }

    private JettyFuseki(JettyServerConfig config) {
        this.serverConfig = config;
        this.buildServerWebapp(this.serverConfig.contextPath, this.serverConfig.jettyConfigFile);
        if (this.mgtConnector == null) {
            this.mgtConnector = this.serverConnector;
        }
        if (config.enableCompression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler(this.server.getHandler());
            this.server.setHandler((Handler)gzipHandler);
        }
    }

    public void start() {
        String host;
        String version = Fuseki.VERSION;
        String buildDate = Fuseki.BUILD_DATE;
        if (version != null && version.equals("${project.version}")) {
            version = null;
        }
        if (buildDate != null && buildDate.equals("${build.time.xsd}")) {
            buildDate = DateTimeUtils.nowAsXSDDateTimeString();
        }
        if (version != null) {
            if (Fuseki.developmentMode && buildDate != null) {
                Fuseki.serverLog.info(String.format("%s %s %s", "Apache Jena Fuseki", version, buildDate));
            } else {
                Fuseki.serverLog.info(String.format("%s %s", "Apache Jena Fuseki", version));
            }
        }
        if ((host = this.serverConnector.getHost()) != null) {
            Fuseki.serverLog.info("Incoming connections limited to " + host);
        }
        try {
            this.server.start();
        }
        catch (BindException ex) {
            Fuseki.serverLog.error("SPARQLServer (port=" + this.serverConnector.getPort() + "): Failed to start server: " + ex.getMessage());
            throw new FusekiException("BindException: port=" + this.serverConnector.getPort() + ": Failed to start server: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to start server: " + ex.getMessage(), (Throwable)ex);
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
        String now = DateTimeUtils.nowAsString();
        Fuseki.serverLog.info(String.format("Started %s on port %d", now, this.serverConnector.getPort()));
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        String now = DateTimeUtils.nowAsString();
        Fuseki.serverLog.info(String.format("Stopped %s on port %d", now, this.serverConnector.getPort()));
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("SPARQLServer: Exception while stopping server: " + ex.getMessage(), (Throwable)ex);
        }
        MgtJMX.removeJMX();
    }

    public static WebAppContext createWebApp(String contextPath) {
        FusekiEnv.setEnvironment();
        WebAppContext webapp = new WebAppContext();
        webapp.getServletContext().getContextHandler().setMaxFormContentSize(10000000);
        String resourceBase3 = null;
        String resourceBase4 = null;
        if (FusekiEnv.FUSEKI_HOME != null) {
            String HOME = FusekiEnv.FUSEKI_HOME.toString();
            resourceBase3 = HOME + "/" + resourceBase1;
            resourceBase4 = HOME + "/" + resourceBase2;
        }
        String resourceBase = JettyFuseki.tryResourceBase(resourceBase1, null);
        resourceBase = JettyFuseki.tryResourceBase(resourceBase2, resourceBase);
        resourceBase = JettyFuseki.tryResourceBase(resourceBase3, resourceBase);
        if ((resourceBase = JettyFuseki.tryResourceBase(resourceBase4, resourceBase)) == null) {
            if (resourceBase3 == null) {
                Fuseki.serverLog.error("Can't find resourceBase (tried webapp and src/main/webapp)");
            } else {
                Fuseki.serverLog.error("Can't find resourceBase (tried webapp, src/main/webapp, " + resourceBase3 + " and " + resourceBase4 + ")");
            }
            Fuseki.serverLog.error("Failed to start");
            throw new FusekiException("Failed to start");
        }
        webapp.setDescriptor(resourceBase + "/WEB-INF/web.xml");
        webapp.setResourceBase(resourceBase);
        webapp.setContextPath(contextPath);
        webapp.setDisplayName(Fuseki.servletRequestLogName);
        webapp.setParentLoaderPriority(true);
        webapp.setErrorHandler((ErrorHandler)new FusekiErrorHandler());
        return webapp;
    }

    public static String getenv(String name) {
        String x = System.getenv(name);
        if (x == null) {
            x = System.getProperty(name);
        }
        return x;
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get(this.servletContext);
    }

    private static String tryResourceBase(String maybeResourceBase, String currentResourceBase) {
        if (currentResourceBase != null) {
            return currentResourceBase;
        }
        if (maybeResourceBase != null && FileOps.exists((String)maybeResourceBase)) {
            return maybeResourceBase;
        }
        return currentResourceBase;
    }

    private void buildServerWebapp(String contextPath, String jettyConfig) {
        if (jettyConfig != null) {
            this.configServer(jettyConfig);
        } else {
            this.defaultServerConfig(this.serverConfig.port, this.serverConfig.loopback);
        }
        WebAppContext webapp = JettyFuseki.createWebApp(contextPath);
        this.servletContext = webapp.getServletContext();
        this.server.setHandler((Handler)webapp);
        if (jettyConfig == null && this.serverConfig.authConfigFile != null) {
            JettyFuseki.security((ServletContextHandler)webapp, this.serverConfig.authConfigFile);
        }
    }

    private static void security(ServletContextHandler context, String authfile) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"fuseki"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        DefaultIdentityService identService = new DefaultIdentityService();
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(mapping);
        securityHandler.setIdentityService((IdentityService)identService);
        HashLoginService loginService = new HashLoginService("Fuseki Authentication", authfile);
        loginService.setIdentityService((IdentityService)identService);
        securityHandler.setLoginService((LoginService)loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        context.setSecurityHandler((SecurityHandler)securityHandler);
        Fuseki.serverLog.debug("Basic Auth Configuration = " + authfile);
    }

    private void configServer(String jettyConfig) {
        try {
            Fuseki.serverLog.info("Jetty server config file = " + jettyConfig);
            this.server = new Server();
            XmlConfiguration configuration = new XmlConfiguration((InputStream)new FileInputStream(jettyConfig));
            configuration.configure((Object)this.server);
            this.serverConnector = (ServerConnector)this.server.getConnectors()[0];
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to configure server: " + ex.getMessage(), (Throwable)ex);
            throw new FusekiException("Failed to configure a server using configuration file '" + jettyConfig + "'");
        }
    }

    private void defaultServerConfig(int port, boolean loopback) {
        this.server = new Server();
        HttpConnectionFactory f1 = new HttpConnectionFactory();
        f1.getHttpConfiguration().setRequestHeaderSize(524288);
        f1.getHttpConfiguration().setOutputBufferSize(0x500000);
        if (!Fuseki.outputJettyServerHeader) {
            f1.getHttpConfiguration().setSendServerVersion(false);
        }
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{f1});
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        if (loopback) {
            connector.setHost("localhost");
        }
        this.serverConnector = connector;
    }

    static {
        Fuseki.init();
        instance = null;
        contextpath = "/";
    }
}

