/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.conneg;

import javax.servlet.http.HttpServletRequest;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaRange;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.conneg.WebLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConNeg {
    private static Logger log = LoggerFactory.getLogger(ConNeg.class);

    public static MediaType parse(String contentType) {
        try {
            return MediaType.create((String)contentType);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static MediaType match(String headerString, AcceptList offerList) {
        AcceptList l = new AcceptList(headerString);
        return AcceptList.match((AcceptList)l, (AcceptList)offerList);
    }

    public static String match(String headerString, String mediaRangeStr) {
        AcceptList l = new AcceptList(headerString);
        MediaRange aItem = new MediaRange(mediaRangeStr);
        MediaRange m = l.match((MediaType)aItem);
        if (m == null) {
            return null;
        }
        return m.toHeaderString();
    }

    static String[] split(String s, String splitStr) {
        String[] x = s.split(splitStr, 2);
        for (int i = 0; i < x.length; ++i) {
            x[i] = x[i].trim();
        }
        return x;
    }

    public static MediaType chooseCharset(HttpServletRequest httpRequest, AcceptList myPrefs, MediaType defaultMediaType) {
        String a = httpRequest.getHeader("Accept-Charset");
        if (log.isDebugEnabled()) {
            log.debug("Accept-Charset request: " + a);
        }
        MediaType item = ConNeg.choose(a, myPrefs, defaultMediaType);
        if (log.isDebugEnabled()) {
            log.debug("Charset chosen: " + item);
        }
        return item;
    }

    public static MediaType chooseContentType(HttpServletRequest httpRequest, AcceptList myPrefs, MediaType defaultMediaType) {
        String a = WebLib.getAccept(httpRequest);
        if (log.isDebugEnabled()) {
            log.debug("Accept request: " + a);
        }
        MediaType item = ConNeg.choose(a, myPrefs, defaultMediaType);
        if (log.isDebugEnabled()) {
            log.debug("Content type chosen: " + item);
        }
        return item;
    }

    private static MediaType choose(String headerString, AcceptList myPrefs, MediaType defaultMediaType) {
        if (headerString == null) {
            return defaultMediaType;
        }
        AcceptList headerList = new AcceptList(headerString);
        if (myPrefs == null) {
            MediaRange i = headerList.first();
            if (i == null) {
                return defaultMediaType;
            }
            return i;
        }
        MediaType i = AcceptList.match((AcceptList)headerList, (AcceptList)myPrefs);
        if (i == null) {
            return defaultMediaType;
        }
        return i;
    }
}

