/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.build.Template;
import org.apache.jena.riot.Lang;
import org.apache.jena.util.FileUtils;

public class TemplateFunctions {
    public static String templateFile(String templateName, Map<String, String> params, Lang lang) {
        String template;
        String templateFilename = Template.getPath(templateName).toString();
        try {
            template = FileUtils.readWholeFileAsUTF8((String)templateFilename);
        }
        catch (IOException ex) {
            Fuseki.serverLog.error("File not found: " + templateFilename);
            IO.exception((IOException)ex);
            return null;
        }
        return TemplateFunctions.templateString(template, params, lang);
    }

    public static String templateResource(String resourceName, Map<String, String> params, Lang lang) {
        String template;
        try {
            InputStream in = TemplateFunctions.class.getClassLoader().getResourceAsStream(resourceName);
            if (in == null) {
                Fuseki.serverLog.error("Resource not found: " + resourceName);
            }
            template = FileUtils.readWholeFileAsUTF8((InputStream)in);
        }
        catch (IOException ex) {
            Fuseki.serverLog.error("Error reading resource: " + resourceName);
            IO.exception((IOException)ex);
            return null;
        }
        return TemplateFunctions.templateString(template, params, lang);
    }

    public static String templateString(String template, Map<String, String> params, Lang lang) {
        for (Map.Entry<String, String> e : params.entrySet()) {
            String x = e.getValue();
            String k = "{" + e.getKey() + "}";
            if (lang != null && (Lang.TTL.equals((Object)lang) || Lang.TRIG.equals((Object)lang) || Lang.NT.equals((Object)lang) || Lang.NQ.equals((Object)lang) || Lang.JSONLD.equals((Object)lang) || Lang.RDFJSON.equals((Object)lang))) {
                x = x.replace("\\", "\\\\");
                x = x.replace("\"", "\\\"");
            }
            template = template.replace(k, x);
        }
        return template;
    }
}

