/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.sequential;

import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressMonitorOutput;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class BuilderSecondaryIndexes {
    public static void createSecondaryIndexes(MonitorOutput output, TupleIndex primaryIndex, TupleIndex[] secondaryIndexes) {
        Timer timer = new Timer();
        timer.startTimer();
        boolean printTiming = true;
        for (TupleIndex index : secondaryIndexes) {
            if (index == null) continue;
            ProgressMonitorOutput monitor = ProgressMonitorOutput.create(output, index.getName(), 1000000L, 10);
            monitor.startMessage();
            monitor.start();
            long time1 = timer.readTimer();
            LoaderOps.copyIndex(primaryIndex.all(), new TupleIndex[]{index}, monitor);
            long time2 = timer.readTimer();
            monitor.finish();
            monitor.finishMessage(index.getName() + " indexing: ");
        }
    }
}

