/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.util.Objects;
import java.util.function.Function;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.rdfconnection.LibRDFConn;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;

public class RDFConnectionRemoteBuilder {
    static String SameAsDestination = "";
    protected Transactional txnLifecycle = TransactionalLock.createMRPlusSW();
    protected HttpClient httpClient = null;
    protected HttpContext httpContext = null;
    protected String destination = null;
    protected String sQuery = SameAsDestination;
    protected String sUpdate = SameAsDestination;
    protected String sGSP = SameAsDestination;
    protected String queryURL = null;
    protected String updateURL = null;
    protected String gspURL = null;
    protected RDFFormat outputQuads = RDFFormat.NQUADS;
    protected RDFFormat outputTriples = RDFFormat.NTRIPLES;
    protected String acceptGraph = "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.5";
    protected String acceptDataset = "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.5,*/*;q=0.5";
    protected String acceptSelectResult = QueryEngineHTTP.defaultSelectHeader();
    protected String acceptAskResult = QueryEngineHTTP.defaultAskHeader();
    protected String acceptSparqlResults = this.acceptSelectResult + "," + this.acceptGraph;
    protected boolean parseCheckQueries = true;
    protected boolean parseCheckUpdates = true;
    private Function<RDFConnectionRemoteBuilder, RDFConnection> creator = null;

    RDFConnectionRemoteBuilder() {
    }

    RDFConnectionRemoteBuilder(RDFConnectionRemote base) {
        Objects.requireNonNull(base);
        this.txnLifecycle = base.txnLifecycle;
        if (this.txnLifecycle == null) {
            this.txnLifecycle = TransactionalLock.createMRPlusSW();
        }
        this.httpClient = base.httpClient;
        this.httpContext = base.httpContext;
        this.destination = base.destination;
        this.sQuery = base.svcQuery;
        this.sUpdate = base.svcUpdate;
        this.sGSP = base.svcGraphStore;
        this.outputQuads = base.outputQuads;
        this.outputTriples = base.outputTriples;
        this.acceptGraph = base.acceptGraph;
        this.acceptDataset = base.acceptDataset;
        this.acceptSelectResult = base.acceptSelectResult;
        this.acceptAskResult = base.acceptAskResult;
        this.parseCheckQueries = base.parseCheckQueries;
        this.parseCheckUpdates = base.parseCheckUpdates;
    }

    public RDFConnectionRemoteBuilder destination(String destination) {
        Objects.requireNonNull(destination);
        this.destination = destination;
        return this;
    }

    public RDFConnectionRemoteBuilder queryEndpoint(String sQuery) {
        this.sQuery = sQuery;
        return this;
    }

    public RDFConnectionRemoteBuilder updateEndpoint(String sUpdate) {
        this.sUpdate = sUpdate;
        return this;
    }

    public RDFConnectionRemoteBuilder gspEndpoint(String sGSP) {
        this.sGSP = sGSP;
        return this;
    }

    private RDFConnectionRemoteBuilder txnLifecycle(Transactional txnLifecycle) {
        this.txnLifecycle = txnLifecycle;
        return this;
    }

    public RDFConnectionRemoteBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public RDFConnectionRemoteBuilder httpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
        return this;
    }

    public RDFConnectionRemoteBuilder quadsFormat(RDFFormat fmtQuads) {
        if (!RDFLanguages.isQuads((Lang)fmtQuads.getLang())) {
            throw new RiotException("Not a language for RDF Datasets: " + fmtQuads);
        }
        this.outputQuads = fmtQuads;
        return this;
    }

    public RDFConnectionRemoteBuilder quadsFormat(Lang langQuads) {
        Objects.requireNonNull(langQuads);
        if (!RDFLanguages.isQuads((Lang)langQuads)) {
            throw new RiotException("Not a language for RDF Datasets: " + langQuads);
        }
        RDFFormat fmt = RDFWriterRegistry.defaultSerialization((Lang)langQuads);
        if (fmt == null) {
            throw new RiotException("Language name not recognized: " + langQuads);
        }
        this.quadsFormat(fmt);
        return this;
    }

    public RDFConnectionRemoteBuilder quadsFormat(String langQuads) {
        Objects.requireNonNull(langQuads);
        Lang lang = RDFLanguages.nameToLang((String)langQuads);
        if (lang == null) {
            throw new RiotException("Language name not recognized: " + langQuads);
        }
        this.quadsFormat(lang);
        return this;
    }

    public RDFConnectionRemoteBuilder triplesFormat(RDFFormat fmtTriples) {
        if (!RDFLanguages.isTriples((Lang)fmtTriples.getLang())) {
            throw new RiotException("Not a language for RDF Graphs: " + fmtTriples);
        }
        this.outputTriples = fmtTriples;
        return this;
    }

    public RDFConnectionRemoteBuilder triplesFormat(Lang langTriples) {
        Objects.requireNonNull(langTriples);
        if (!RDFLanguages.isTriples((Lang)langTriples)) {
            throw new RiotException("Not a language for RDF triples: " + langTriples);
        }
        RDFFormat fmt = RDFWriterRegistry.defaultSerialization((Lang)langTriples);
        if (fmt == null) {
            throw new RiotException("Language name not recognized: " + langTriples);
        }
        this.triplesFormat(fmt);
        return this;
    }

    public RDFConnectionRemoteBuilder triplesFormat(String langTriples) {
        Objects.requireNonNull(langTriples);
        Lang lang = RDFLanguages.nameToLang((String)langTriples);
        if (lang == null) {
            throw new RiotException("Language name not recognized: " + langTriples);
        }
        this.quadsFormat(lang);
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderGraph(String acceptGraph) {
        this.acceptGraph = acceptGraph;
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderDataset(String acceptDataset) {
        this.acceptDataset = acceptDataset;
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderSelectQuery(String acceptSelectHeader) {
        this.acceptSelectResult = acceptSelectHeader;
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderAskQuery(String acceptAskHeader) {
        this.acceptAskResult = acceptAskHeader;
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderQuery(String acceptHeader) {
        this.acceptSparqlResults = acceptHeader;
        return this;
    }

    public RDFConnectionRemoteBuilder parseCheckSPARQL(boolean parseCheck) {
        this.parseCheckQueries = parseCheck;
        this.parseCheckUpdates = parseCheck;
        return this;
    }

    public RDFConnectionRemoteBuilder creator(Function<RDFConnectionRemoteBuilder, RDFConnection> function) {
        this.creator = function;
        return this;
    }

    public RDFConnection build() {
        Objects.requireNonNull(this.txnLifecycle);
        Function<RDFConnectionRemoteBuilder, RDFConnection> maker = this.creator;
        if (maker == null) {
            maker = b -> b.buildConnection();
        }
        this.queryURL = LibRDFConn.formServiceURL(this.destination, this.sQuery);
        this.updateURL = LibRDFConn.formServiceURL(this.destination, this.sUpdate);
        this.gspURL = LibRDFConn.formServiceURL(this.destination, this.sGSP);
        return maker.apply(this);
    }

    protected RDFConnectionRemote buildConnection() {
        return new RDFConnectionRemote(this.txnLifecycle, this.httpClient, this.httpContext, this.destination, this.queryURL, this.updateURL, this.gspURL, this.outputQuads, this.outputTriples, this.acceptDataset, this.acceptGraph, this.acceptSparqlResults, this.acceptSelectResult, this.acceptAskResult, this.parseCheckQueries, this.parseCheckUpdates);
    }
}

