/*
 * Decompiled with CFR 0.152.
 */
package deepgo;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Functions {
    public static final String DEEPGO_API_URI = "http://localhost/deepgo/api/create";
    public static final String NAMESPACE = "http://deepgoplus.bio2vec.net/";

    public static ArrayList<String[]> deepgo(String sequence, double threshold) {
        return Functions.deepgo("latest", sequence, threshold);
    }

    public static ArrayList<String[]> deepgo(String version, String sequence, double threshold) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        String query = new JSONObject().put("version", (Object)version).put("data_format", (Object)"enter").put("data", (Object)sequence).put("threshold", threshold).toString();
        JSONObject obj = Functions.queryAPI(query);
        if (obj == null) {
            return result;
        }
        JSONArray arr = (JSONArray)obj.get("predictions");
        for (int i = 0; i < arr.length(); ++i) {
            obj = (JSONObject)arr.get(i);
            JSONArray funcs = (JSONArray)obj.get("functions");
            for (int j = 0; j < funcs.length(); ++j) {
                obj = (JSONObject)funcs.get(j);
                JSONArray subFuncs = (JSONArray)obj.get("functions");
                for (int k = 0; k < subFuncs.length(); ++k) {
                    JSONArray goArr = (JSONArray)subFuncs.get(k);
                    String goURI = goArr.get(0).toString().replace("GO:", "http://purl.obolibrary.org/obo/GO_");
                    result.add(new String[]{obj.get("name").toString(), goURI, goArr.get(1).toString(), goArr.get(2).toString()});
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject queryAPI(String query) {
        CloseableHttpClient client = HttpClients.createDefault();
        JSONObject result = null;
        try {
            try {
                HttpPost post = new HttpPost(DEEPGO_API_URI);
                StringEntity requestEntity = new StringEntity(query, ContentType.APPLICATION_JSON);
                post.setEntity((HttpEntity)requestEntity);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (statusCode < 200 || statusCode >= 300) {
                        System.err.println("Method failed: " + response.getStatusLine());
                        String responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        System.err.println(responseBody);
                    } else {
                        String responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        result = new JSONObject(responseBody);
                    }
                    EntityUtils.consume((HttpEntity)entity);
                }
            }
            finally {
                client.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

