/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.base;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.data.TransBinaryDataFile;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressMonitor;
import org.apache.jena.tdb2.loader.base.ProgressMonitorFactory;
import org.apache.jena.tdb2.loader.base.ProgressMonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressStreamRDF;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableTRDF;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.store.tupletable.TupleIndexRecord;
import org.slf4j.Logger;

public class LoaderOps {
    private static Logger LOG = TDB2.logLoader;

    public static TransBinaryDataFile ntDataFile(NodeTable nt) {
        NodeTableTRDF ntt = (NodeTableTRDF)nt.baseNodeTable();
        BinaryDataFile bdf = ntt.getData();
        TransBinaryDataFile tbdf = (TransBinaryDataFile)bdf;
        return tbdf;
    }

    public static BPlusTree ntBPTree(NodeTable nt) {
        NodeTableTRDF ntt = (NodeTableTRDF)nt.baseNodeTable();
        Index idx = ntt.getIndex();
        return (BPlusTree)idx;
    }

    public static BPlusTree idxBTree(TupleIndex idx) {
        TupleIndexRecord idxr = (TupleIndexRecord)idx;
        RangeIndex rIndex = idxr.getRangeIndex();
        BPlusTree bpt = (BPlusTree)rIndex;
        return bpt;
    }

    private static StreamRDF streamWithProgressMonitor(StreamRDF dest, String label, MonitorOutput output, int dataTickPoint, int dataSuperTick) {
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create(output, label, (long)dataTickPoint, dataSuperTick);
        return new ProgressStreamRDF(dest, monitor);
    }

    private static String label(String fileName) {
        String basename = (String)FileOps.splitDirFile((String)fileName).get(1);
        return basename;
    }

    public static void inputFile(StreamRDF dest, String source, MonitorOutput output, int dataTickPoint, int dataSuperTick) {
        Objects.requireNonNull(dest);
        ProgressMonitor monitor = null;
        if (output != null) {
            monitor = ProgressMonitorFactory.progressMonitor(LoaderOps.label(source), output, dataTickPoint, dataSuperTick);
        }
        LoaderOps.inputFile(dest, source, monitor);
    }

    public static void inputFile(StreamRDF sink, String source, ProgressMonitor monitor) {
        if (monitor != null) {
            sink = new ProgressStreamRDF((StreamRDF)sink, monitor);
            monitor.start();
        }
        sink.start();
        RDFDataMgr.parse((StreamRDF)sink, (String)source);
        sink.finish();
        if (monitor != null) {
            monitor.finish();
            monitor.finishMessage("Data: " + source);
        }
    }

    public static void copyIndex(Iterator<Tuple<NodeId>> srcIter, TupleIndex[] destIndexes, ProgressMonitor monitor) {
        long counter = 0L;
        while (srcIter.hasNext()) {
            ++counter;
            Tuple<NodeId> tuple = srcIter.next();
            monitor.tick();
            for (TupleIndex destIdx : destIndexes) {
                if (destIdx == null) continue;
                destIdx.add(tuple);
            }
        }
    }

    public static StreamRDF toNamedGraph(StreamRDF stream, final Node graphName) {
        Objects.requireNonNull(stream);
        if (graphName == null) {
            return stream;
        }
        return new StreamRDFWrapper(stream){

            public void triple(Triple triple) {
                super.quad(Quad.create((Node)graphName, (Triple)triple));
            }

            public void quad(Quad quad) {
            }
        };
    }

    public static MonitorOutput nullOutput() {
        return (x, y) -> {};
    }

    public static MonitorOutput outputToLog() {
        return LoaderOps.outputToLog(LOG);
    }

    public static MonitorOutput outputToLog(Logger logger) {
        Objects.requireNonNull(logger);
        return (fmt, args) -> {
            if (logger.isInfoEnabled()) {
                FmtLog.info((Logger)logger, (String)fmt, (Object[])args);
            }
        };
    }

    public static MonitorOutput outputTo(PrintStream output) {
        Objects.requireNonNull(output);
        return (fmt, args) -> {
            if (fmt.endsWith("\n") || fmt.endsWith("\r")) {
                output.print(String.format(fmt, args));
            } else {
                output.println(String.format(fmt, args));
            }
        };
    }
}

