/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.dboe.transaction.txn.SysTrans;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionInfo;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.dboe.transaction.txn.TxnState;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;

public final class Transaction
implements TransactionInfo {
    private TransactionCoordinator txnMgr;
    private final TxnId txnId;
    private final List<SysTrans> components;
    private final AtomicReference<TxnState> state = new AtomicReference();
    private final long dataVersion;
    private final TxnType txnType;
    private ReadWrite mode;

    public Transaction(TransactionCoordinator txnMgr, TxnType txnType, ReadWrite readWrite, TxnId txnId, long dataVersion, List<SysTrans> components) {
        Objects.requireNonNull(txnMgr);
        Objects.requireNonNull(txnId);
        Objects.requireNonNull(readWrite);
        Objects.requireNonNull(components);
        this.txnMgr = txnMgr;
        this.txnId = txnId;
        this.txnType = txnType;
        this.mode = readWrite;
        this.dataVersion = dataVersion;
        this.components = components;
        this.setState(TxnState.INACTIVE);
    }

    void setState(TxnState newState) {
        this.state.set(newState);
    }

    @Override
    public TxnState getState() {
        return this.state.get();
    }

    @Override
    public long getDataVersion() {
        return this.dataVersion;
    }

    public void begin() {
        this.checkState(TxnState.INACTIVE);
        this.components.forEach(c -> c.begin());
        this.setState(TxnState.ACTIVE);
    }

    private boolean promoteReadCommitted() {
        if (this.txnType == TxnType.READ_COMMITTED_PROMOTE) {
            return true;
        }
        if (this.txnType == TxnType.READ_PROMOTE) {
            return false;
        }
        return false;
    }

    public boolean promote() {
        return this.promote(this.promoteReadCommitted());
    }

    public boolean promote(boolean readCommitted) {
        this.checkState(TxnState.ACTIVE);
        if (this.txnType == TxnType.READ) {
            return false;
        }
        boolean b = this.txnMgr.promoteTxn(this, readCommitted);
        if (!b) {
            return false;
        }
        this.mode = ReadWrite.WRITE;
        return true;
    }

    void promoteComponents() {
        this.components.forEach(c -> {
            if (!c.promote()) {
                throw new TransactionException("Failed to promote");
            }
        });
        this.mode = ReadWrite.WRITE;
    }

    public void notifyUpdate() {
        this.checkState(TxnState.ACTIVE);
        if (this.mode == ReadWrite.READ) {
            this.promote(this.promoteReadCommitted());
            this.mode = ReadWrite.WRITE;
        }
    }

    public void prepare() {
        this.checkState(TxnState.ACTIVE);
        if (this.mode == ReadWrite.WRITE) {
            this.txnMgr.executePrepare(this);
        }
        this.setState(TxnState.PREPARE);
    }

    public void commit() {
        TxnState s = this.getState();
        if (s == TxnState.ACTIVE) {
            this.prepare();
        }
        this.checkState(TxnState.PREPARE);
        this.setState(TxnState.COMMIT);
        switch (this.mode) {
            case WRITE: {
                this.txnMgr.executeCommit(this, () -> this.components.forEach(c -> c.commit()), () -> this.components.forEach(c -> c.commitEnd()));
                break;
            }
            case READ: {
                this.txnMgr.executeCommit(this, () -> this.components.forEach(c -> c.commit()), () -> this.components.forEach(c -> c.commitEnd()));
            }
        }
        this.setState(TxnState.COMMITTED);
        this.endInternal();
    }

    public void abort() {
        this.abort$();
        this.endInternal();
    }

    private void abort$() {
        this.checkState(TxnState.ACTIVE, TxnState.ABORTED);
        this.txnMgr.executeAbort(this, () -> this.components.forEach(c -> c.abort()));
        this.setState(TxnState.ABORTED);
    }

    public void end() {
        this.txnMgr.notifyEndStart(this);
        if (this.isWriteTxn() && this.getState() == TxnState.ACTIVE) {
            this.abort$();
            this.endInternal();
            throw new TransactionException("Write transaction with no commit() or abort() before end() - forced abort");
        }
        this.endInternal();
        this.txnMgr.notifyEndFinish(this);
        this.txnMgr = null;
    }

    private void endInternal() {
        if (this.hasFinalised()) {
            return;
        }
        this.txnMgr.notifyCompleteStart(this);
        this.components.forEach(c -> c.complete());
        this.txnMgr.completed(this);
        if (this.getState() == TxnState.COMMITTED) {
            this.setState(TxnState.END_COMMITTED);
        } else {
            this.setState(TxnState.END_ABORTED);
        }
        this.txnMgr.notifyCompleteFinish(this);
    }

    List<SysTrans> getComponents() {
        return this.components;
    }

    void detach() {
        this.checkState(TxnState.ACTIVE, TxnState.PREPARE);
        this.setState(TxnState.DETACHED);
    }

    void attach() {
        this.checkState(TxnState.DETACHED);
        this.setState(TxnState.ACTIVE);
    }

    public void requireWriteTxn() {
        this.checkState(TxnState.ACTIVE);
        if (this.mode != ReadWrite.WRITE) {
            throw new TransactionException("Not a write transaction");
        }
    }

    @Override
    public boolean hasStarted() {
        TxnState x = this.getState();
        return x == TxnState.INACTIVE;
    }

    @Override
    public boolean hasFinished() {
        TxnState x = this.getState();
        return x == TxnState.COMMITTED || x == TxnState.ABORTED || x == TxnState.END_COMMITTED || x == TxnState.END_ABORTED;
    }

    @Override
    public boolean hasFinalised() {
        TxnState x = this.getState();
        return x == TxnState.END_COMMITTED || x == TxnState.END_ABORTED;
    }

    @Override
    public TxnId getTxnId() {
        return this.txnId;
    }

    @Override
    public TxnType getTxnType() {
        return this.txnType;
    }

    @Override
    public ReadWrite getMode() {
        return this.mode;
    }

    @Override
    public boolean isReadTxn() {
        return this.mode == ReadWrite.READ;
    }

    @Override
    public boolean isWriteTxn() {
        return this.mode == ReadWrite.WRITE;
    }

    private void checkWriteTxn() {
        if (!this.isActiveTxn() || !this.isWriteTxn()) {
            throw new TransactionException("Not in a write transaction");
        }
    }

    private void checkState(TxnState expected) {
        TxnState s = this.getState();
        if (s != expected) {
            throw new TransactionException("Transaction is in state " + (Object)((Object)s) + ": expected state " + (Object)((Object)expected));
        }
    }

    private void checkState(TxnState expected1, TxnState expected2) {
        TxnState s = this.getState();
        if (s != expected1 && s != expected2) {
            throw new TransactionException("Transaction is in state " + (Object)((Object)s) + ": expected state " + (Object)((Object)expected1) + " or " + (Object)((Object)expected2));
        }
    }

    private void checkState(TxnState expected1, TxnState expected2, TxnState expected3) {
        TxnState s = this.getState();
        if (s != expected1 && s != expected2 && s != expected3) {
            throw new TransactionException("Transaction is in state " + (Object)((Object)s) + ": expected state " + (Object)((Object)expected1) + ", " + (Object)((Object)expected2) + " or " + (Object)((Object)expected3));
        }
    }

    @Override
    public boolean isActiveTxn() {
        return this.getState() != TxnState.INACTIVE;
    }
}

